/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.table.api.TableRuntimeException;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.types.variant.BinaryVariantInternalBuilder;
import org.apache.flink.types.variant.Variant;

public class ParseJsonFunction
extends BuiltInScalarFunction {
    public ParseJsonFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.PARSE_JSON, context);
    }

    @Nullable
    public Variant eval(@Nullable StringData jsonStr) {
        return this.eval(jsonStr, false);
    }

    @Nullable
    public Variant eval(@Nullable StringData jsonStr, boolean allowDuplicateKeys) {
        if (jsonStr == null) {
            return null;
        }
        try {
            return BinaryVariantInternalBuilder.parseJson((String)jsonStr.toString(), (boolean)allowDuplicateKeys);
        }
        catch (Throwable e) {
            throw new TableRuntimeException(String.format("Failed to parse json string: %s", jsonStr), e);
        }
    }
}

