/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayContainsFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final SpecializedFunction.ExpressionEvaluator equalityEvaluator;
    private transient MethodHandle equalityHandle;

    public ArrayContainsFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_CONTAINS, context);
        DataType needleDataType = (DataType)context.getCallContext().getArgumentDataTypes().get(1);
        this.elementGetter = ArrayData.createElementGetter((LogicalType)needleDataType.getLogicalType());
        this.equalityEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element").isEqual((Object)Expressions.$((String)"needle")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element", (DataType)((DataType)needleDataType.notNull()).toInternal()), DataTypes.FIELD((String)"needle", (DataType)((DataType)needleDataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.equalityHandle = this.equalityEvaluator.open(context);
    }

    @Nullable
    public Boolean eval(ArrayData haystack, Object needle) {
        try {
            if (haystack == null) {
                return null;
            }
            int size = haystack.size();
            for (int pos = 0; pos < size; ++pos) {
                boolean isEqual;
                Object element = this.elementGetter.getElementOrNull(haystack, pos);
                if (needle == null && element == null) {
                    return true;
                }
                if (needle == null || element == null || !(isEqual = this.equalityHandle.invoke(element, needle))) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    public void close() throws Exception {
        this.equalityEvaluator.close();
    }
}

