/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SqlResource;

class SqlResourceQueryResultPusher
extends QueryResultPusher {
    private static final Logger log = new Logger(SqlResourceQueryResultPusher.class);
    private final ObjectMapper jsonMapper;
    private final String sqlQueryId;
    private final HttpStatement stmt;
    private final SqlQuery sqlQuery;
    private final ServerConfig serverConfig;

    public SqlResourceQueryResultPusher(ObjectMapper jsonMapper, ResponseContextConfig responseContextConfig, DruidNode selfNode, ServerConfig serverConfig, HttpServletRequest req, HttpStatement stmt, SqlQuery sqlQuery, Map<String, String> headers) {
        super(req, jsonMapper, responseContextConfig, selfNode, (QueryResource.QueryMetricCounter)SqlResource.QUERY_METRIC_COUNTER, stmt.sqlQueryId(), MediaType.APPLICATION_JSON_TYPE, headers, sqlQuery.getContext());
        this.serverConfig = serverConfig;
        this.jsonMapper = jsonMapper;
        this.sqlQueryId = stmt.sqlQueryId();
        this.stmt = stmt;
        this.sqlQuery = sqlQuery;
    }

    public QueryResultPusher.ResultsWriter start() {
        return new QueryResultPusher.ResultsWriter(){
            private QueryResponse<Object[]> queryResponse;
            private DirectStatement.ResultSet thePlan;

            @Nullable
            public Response.ResponseBuilder start() {
                this.thePlan = SqlResourceQueryResultPusher.this.stmt.plan();
                this.queryResponse = this.thePlan.run();
                return null;
            }

            public QueryResponse<Object> getQueryResponse() {
                return this.queryResponse;
            }

            public QueryResultPusher.Writer makeWriter(OutputStream out) throws IOException {
                final ResultFormat.Writer writer = SqlResourceQueryResultPusher.this.sqlQuery.getResultFormat().createFormatter(out, SqlResourceQueryResultPusher.this.jsonMapper);
                final SqlRowTransformer rowTransformer = this.thePlan.createRowTransformer();
                return new QueryResultPusher.Writer(){

                    public void writeResponseStart() throws IOException {
                        writer.writeResponseStart();
                        if (SqlResourceQueryResultPusher.this.sqlQuery.includeHeader()) {
                            writer.writeHeader(rowTransformer.getRowType(), SqlResourceQueryResultPusher.this.sqlQuery.includeTypesHeader(), SqlResourceQueryResultPusher.this.sqlQuery.includeSqlTypesHeader());
                        }
                    }

                    public void writeRow(Object obj) throws IOException {
                        Object[] row = (Object[])obj;
                        writer.writeRowStart();
                        for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                            Object value = rowTransformer.transform(row, i);
                            writer.writeRowField(rowTransformer.getFieldList().get(i), value);
                        }
                        writer.writeRowEnd();
                    }

                    public void writeResponseEnd() throws IOException {
                        writer.writeResponseEnd();
                    }

                    public void close() throws IOException {
                        writer.close();
                    }
                };
            }

            public void recordSuccess(long numBytes) {
                SqlResourceQueryResultPusher.this.stmt.reporter().succeeded(numBytes);
            }

            public void recordFailure(Exception e) {
                if (QueryLifecycle.shouldLogStackTrace((Throwable)e, (QueryContext)SqlResourceQueryResultPusher.this.sqlQuery.queryContext())) {
                    log.warn((Throwable)e, "Exception while processing sqlQueryId[%s]", new Object[]{SqlResourceQueryResultPusher.this.sqlQueryId});
                } else {
                    log.noStackTrace().warn((Throwable)e, "Exception while processing sqlQueryId[%s]", new Object[]{SqlResourceQueryResultPusher.this.sqlQueryId});
                }
                SqlResourceQueryResultPusher.this.stmt.reporter().failed(e);
            }

            public void close() {
                SqlResourceQueryResultPusher.this.stmt.close();
            }
        };
    }

    public void writeException(Exception ex, OutputStream out) throws IOException {
        if (ex instanceof SanitizableException) {
            ex = this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)ex);
        }
        out.write(this.jsonMapper.writeValueAsBytes((Object)ex));
    }
}

