/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.druid.catalog.model.facade.DatasourceFacade;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.sql.calcite.table.DatasourceMetadata;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DatasourceTable
extends DruidTable {
    private final DatasourceMetadata physicalMetadata;
    private final EffectiveMetadata effectiveMetadata;

    public DatasourceTable(PhysicalDatasourceMetadata physicalMetadata) {
        this(physicalMetadata.getRowSignature(), physicalMetadata, EffectiveMetadata.of(physicalMetadata.getRowSignature()));
    }

    public DatasourceTable(RowSignature rowSignature, DatasourceMetadata physicalMetadata, EffectiveMetadata effectiveMetadata) {
        super(rowSignature);
        this.physicalMetadata = physicalMetadata;
        this.effectiveMetadata = effectiveMetadata;
    }

    @Override
    public DataSource getDataSource() {
        return this.physicalMetadata.dataSource();
    }

    @Override
    public boolean isJoinable() {
        return this.physicalMetadata.isJoinable();
    }

    @Override
    public boolean isBroadcast() {
        return this.physicalMetadata.isBroadcast();
    }

    public EffectiveMetadata effectiveMetadata() {
        return this.effectiveMetadata;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)table, (List)context.getTableHints());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasourceTable that = (DatasourceTable)o;
        if (!Objects.equals(this.physicalMetadata, that.physicalMetadata)) {
            return false;
        }
        return Objects.equals(this.getRowSignature(), that.getRowSignature());
    }

    @Override
    public int hashCode() {
        return this.physicalMetadata.hashCode();
    }

    @Override
    public String toString() {
        return "DruidTable{physicalMetadata=" + (this.physicalMetadata == null ? "null" : this.physicalMetadata.toString()) + ", effectiveMetadata=" + this.effectiveMetadata + "}";
    }

    public static class PhysicalDatasourceMetadata
    extends DataSourceInformation
    implements DatasourceMetadata {
        private final TableDataSource tableDataSource;
        private final boolean joinable;
        private final boolean broadcast;

        public PhysicalDatasourceMetadata(TableDataSource tableDataSource, RowSignature rowSignature, boolean isJoinable, boolean isBroadcast) {
            super(tableDataSource.getName(), rowSignature);
            this.tableDataSource = (TableDataSource)Preconditions.checkNotNull((Object)tableDataSource, (Object)"dataSource");
            this.joinable = isJoinable;
            this.broadcast = isBroadcast;
        }

        public TableDataSource dataSource() {
            return this.tableDataSource;
        }

        @Override
        public boolean isJoinable() {
            return this.joinable;
        }

        @Override
        public boolean isBroadcast() {
            return this.broadcast;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PhysicalDatasourceMetadata that = (PhysicalDatasourceMetadata)o;
            return Objects.equals(this.tableDataSource, that.tableDataSource);
        }

        public int hashCode() {
            int result = this.tableDataSource != null ? this.tableDataSource.hashCode() : 0;
            result = 31 * result + super.hashCode();
            return result;
        }

        public String toString() {
            return "DatasourceMetadata{dataSource=" + this.tableDataSource + ", rowSignature=" + this.getRowSignature() + "}";
        }
    }

    public static class EffectiveMetadata {
        private final DatasourceFacade catalogMetadata;
        private final boolean isEmpty;
        private final Map<String, EffectiveColumnMetadata> columns;

        public EffectiveMetadata(DatasourceFacade catalogMetadata, Map<String, EffectiveColumnMetadata> columns, boolean isEmpty) {
            this.catalogMetadata = catalogMetadata;
            this.isEmpty = isEmpty;
            this.columns = columns;
        }

        public static Map<String, EffectiveColumnMetadata> toEffectiveColumns(RowSignature rowSignature) {
            HashMap<String, EffectiveColumnMetadata> columns = new HashMap<String, EffectiveColumnMetadata>();
            for (int i = 0; i < rowSignature.size(); ++i) {
                String colName = rowSignature.getColumnName(i);
                ColumnType colType = (ColumnType)rowSignature.getColumnType(i).get();
                EffectiveColumnMetadata colMetadata = EffectiveColumnMetadata.fromPhysical(colName, colType);
                columns.put(colName, colMetadata);
            }
            return columns;
        }

        public static EffectiveMetadata of(RowSignature rowSignature) {
            return new EffectiveMetadata(null, EffectiveMetadata.toEffectiveColumns(rowSignature), false);
        }

        public DatasourceFacade catalogMetadata() {
            return this.catalogMetadata;
        }

        public EffectiveColumnMetadata column(String name) {
            return this.columns.get(name);
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{empty=" + this.isEmpty + ", columns=" + this.columns + "}";
        }
    }

    public static class EffectiveColumnMetadata {
        protected final String name;
        protected final ColumnType type;

        public EffectiveColumnMetadata(String name, ColumnType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public ColumnType druidType() {
            return this.type;
        }

        public static EffectiveColumnMetadata fromPhysical(String name, ColumnType type) {
            return new EffectiveColumnMetadata(name, type);
        }

        public String toString() {
            return "Column{name=" + this.name + ", type=" + this.type.asTypeString() + "}";
        }
    }
}

