/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class RewriteFirstValueLastValueRule
extends RelOptRule
implements SubstitutionRule {
    public RewriteFirstValueLastValueRule() {
        super(RewriteFirstValueLastValueRule.operand(RelNode.class, (RelOptRuleOperandChildren)RewriteFirstValueLastValueRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        RewriteShuttle shuttle;
        RelNode oldNode = call.rel(0);
        RelNode newNode = oldNode.accept((RexShuttle)(shuttle = new RewriteShuttle(oldNode.getCluster().getRexBuilder())));
        if (newNode != oldNode) {
            call.transformTo(newNode);
            call.getPlanner().prune(oldNode);
        }
    }

    private static class RewriteShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public RewriteShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitOver(RexOver over) {
            SqlOperator operator = over.getOperator();
            RexWindow window = over.getWindow();
            RexWindowBound upperBound = window.getUpperBound();
            RexWindowBound lowerBound = window.getLowerBound();
            if (window.orderKeys.size() > 0) {
                if (operator.getKind() == SqlKind.LAST_VALUE && !upperBound.isUnbounded() && upperBound.isCurrentRow()) {
                    return this.rewriteToReferenceCurrentRow(over);
                }
                if (operator.getKind() == SqlKind.FIRST_VALUE && !lowerBound.isUnbounded() && lowerBound.isCurrentRow()) {
                    return this.rewriteToReferenceCurrentRow(over);
                }
            }
            return super.visitOver(over);
        }

        private RexNode rewriteToReferenceCurrentRow(RexOver over) {
            return this.makeOver(over, over.getWindow(), SqlStdOperatorTable.LAG, (List<RexNode>)ImmutableList.of((Object)((RexNode)over.getOperands().get(0)), (Object)this.rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
        }

        private RexNode makeOver(RexOver over, RexWindow window, SqlAggFunction aggFunction, List<RexNode> operands) {
            return this.rexBuilder.makeOver(over.type, aggFunction, operands, (List)window.partitionKeys, window.orderKeys, window.getLowerBound(), window.getUpperBound(), window.isRows(), true, false, over.isDistinct(), over.ignoreNulls());
        }
    }
}

