/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.ArrayConcatSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.ArraySqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.AvgSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.BitwiseSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.BuiltinApproxCountDistinctSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.EarliestLatestAnySqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.EarliestLatestBySqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.GroupingSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.LiteralSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.MaxSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.MinSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SingleValueSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.StringSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SumSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SumZeroSqlAggregator;
import org.apache.druid.sql.calcite.expression.AliasedOperatorConversion;
import org.apache.druid.sql.calcite.expression.BinaryOperatorConversion;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.UnaryPrefixOperatorConversion;
import org.apache.druid.sql.calcite.expression.WindowSqlAggregate;
import org.apache.druid.sql.calcite.expression.builtin.ArrayAppendOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayConcatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayConstructorOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayContainsOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayLengthOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOffsetOfOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOffsetOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOrdinalOfOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOrdinalOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOverlapOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayPrependOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayQuantileOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArraySliceOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayToMultiValueStringOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayToStringOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.BTrimOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.CastOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.CeilOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.CoalesceOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ComplexDecodeBase64OperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ConcatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ContainsOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.DateTruncOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.DecodeBase64UTFOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.DivOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ExtractOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.FloorOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.GreatestOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.HumanReadableFormatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.IPv4AddressMatchOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.IPv4AddressParseOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.IPv4AddressStringifyOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.IPv6AddressMatchOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LPadOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LTrimOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LeastOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LeftOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LikeOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.MillisToTimestampOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.MultiValueStringOperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.MultiValueStringToArrayOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.NestedDataOperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.ParseLongOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.PositionOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RPadOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RTrimOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RegexpExtractOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RegexpLikeOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RegexpReplaceOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ReinterpretOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RepeatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ReverseOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RightOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.SafeDivideOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ScalarInArrayOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.SearchOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StringFormatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StringToArrayOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StrposOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.SubstringOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TextcatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeArithmeticOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeCeilOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeExtractOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeFormatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeParseOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeShiftOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimestampToMillisOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TrimOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TruncateOperatorConversion;
import org.apache.druid.sql.calcite.external.TableAppendMacro;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletTable;

public class DruidOperatorTable
implements SqlOperatorTable {
    private static final List<SqlAggregator> STANDARD_AGGREGATORS = ImmutableList.builder().add((Object)new WindowSqlAggregate(SqlStdOperatorTable.LAG)).add((Object)new WindowSqlAggregate(SqlStdOperatorTable.LEAD)).add((Object)new WindowSqlAggregate(SqlStdOperatorTable.FIRST_VALUE)).add((Object)new WindowSqlAggregate(SqlStdOperatorTable.LAST_VALUE)).add((Object)new WindowSqlAggregate((SqlAggFunction)SqlStdOperatorTable.CUME_DIST)).add((Object)new WindowSqlAggregate((SqlAggFunction)SqlStdOperatorTable.DENSE_RANK)).add((Object)new WindowSqlAggregate(SqlStdOperatorTable.NTILE)).add((Object)new WindowSqlAggregate((SqlAggFunction)SqlStdOperatorTable.PERCENT_RANK)).add((Object)new WindowSqlAggregate((SqlAggFunction)SqlStdOperatorTable.RANK)).add((Object)new WindowSqlAggregate((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER)).add((Object)new BuiltinApproxCountDistinctSqlAggregator()).add((Object)new AvgSqlAggregator()).add((Object)EarliestLatestAnySqlAggregator.EARLIEST).add((Object)EarliestLatestAnySqlAggregator.LATEST).add((Object)EarliestLatestAnySqlAggregator.ANY_VALUE).add((Object)EarliestLatestBySqlAggregator.EARLIEST_BY).add((Object)EarliestLatestBySqlAggregator.LATEST_BY).add((Object)new MinSqlAggregator()).add((Object)new MaxSqlAggregator()).add((Object)new SumSqlAggregator()).add((Object)new SumZeroSqlAggregator()).add((Object)new GroupingSqlAggregator()).add((Object)new LiteralSqlAggregator()).add((Object)new ArraySqlAggregator()).add((Object)new ArrayConcatSqlAggregator()).add((Object)StringSqlAggregator.STRING_AGG).add((Object)StringSqlAggregator.LISTAGG).add((Object)new BitwiseSqlAggregator(BitwiseSqlAggregator.Op.AND)).add((Object)new BitwiseSqlAggregator(BitwiseSqlAggregator.Op.OR)).add((Object)new BitwiseSqlAggregator(BitwiseSqlAggregator.Op.XOR)).add((Object)new SingleValueSqlAggregator()).build();
    private static final SqlOperatorConversion CHARACTER_LENGTH_CONVERSION = new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, "strlen");
    private static final List<SqlOperatorConversion> TIME_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new CeilOperatorConversion()).add((Object)new DateTruncOperatorConversion()).add((Object)new ExtractOperatorConversion()).add((Object)new FloorOperatorConversion()).add((Object)new MillisToTimestampOperatorConversion()).add((Object)new TimeArithmeticOperatorConversion.TimeMinusIntervalOperatorConversion()).add((Object)new TimeArithmeticOperatorConversion.TimePlusIntervalOperatorConversion()).add((Object)new TimeExtractOperatorConversion()).add((Object)new TimeCeilOperatorConversion()).add((Object)new TimeFloorOperatorConversion()).add((Object)new TimeFormatOperatorConversion()).add((Object)new TimeParseOperatorConversion()).add((Object)new TimeShiftOperatorConversion()).add((Object)new TimestampToMillisOperatorConversion()).build();
    private static final List<SqlOperatorConversion> STRING_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new BTrimOperatorConversion()).add((Object)new LikeOperatorConversion()).add((Object)new LTrimOperatorConversion()).add((Object)new PositionOperatorConversion()).add((Object)new RegexpExtractOperatorConversion()).add((Object)new RegexpLikeOperatorConversion()).add((Object)new RegexpReplaceOperatorConversion()).add((Object)new RTrimOperatorConversion()).add((Object)new ParseLongOperatorConversion()).add((Object)new StringFormatOperatorConversion()).add((Object)new StrposOperatorConversion()).add((Object)new SubstringOperatorConversion()).add((Object)new RightOperatorConversion()).add((Object)new LeftOperatorConversion()).add((Object)new ReverseOperatorConversion()).add((Object)new RepeatOperatorConversion()).add((Object)new AliasedOperatorConversion(new SubstringOperatorConversion(), "SUBSTR")).add((Object)new ConcatOperatorConversion()).add((Object)new TextcatOperatorConversion()).add((Object)new TrimOperatorConversion()).add((Object)new TruncateOperatorConversion()).add((Object)new AliasedOperatorConversion(new TruncateOperatorConversion(), "TRUNC")).add((Object)new LPadOperatorConversion()).add((Object)new RPadOperatorConversion()).add((Object)ContainsOperatorConversion.caseSensitive()).add((Object)ContainsOperatorConversion.caseInsensitive()).build();
    private static final SqlOperatorConversion COMPLEX_DECODE_OPERATOR_CONVERSIONS = new ComplexDecodeBase64OperatorConversion();
    private static final List<SqlOperatorConversion> VALUE_COERCION_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new CastOperatorConversion()).add((Object)new ReinterpretOperatorConversion()).add((Object)COMPLEX_DECODE_OPERATOR_CONVERSIONS).add((Object)new AliasedOperatorConversion(COMPLEX_DECODE_OPERATOR_CONVERSIONS, "decode_base64_complex")).add((Object)new DecodeBase64UTFOperatorConversion()).build();
    private static final List<SqlOperatorConversion> ARRAY_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new ArrayConstructorOperatorConversion()).add((Object)new ArrayContainsOperatorConversion()).add((Object)new ArrayConcatOperatorConversion()).add((Object)new ArrayOverlapOperatorConversion()).add((Object)new ArrayAppendOperatorConversion()).add((Object)new ArrayPrependOperatorConversion()).add((Object)new ArrayLengthOperatorConversion()).add((Object)new ArrayOffsetOperatorConversion()).add((Object)new ArrayOrdinalOperatorConversion()).add((Object)new ArrayOffsetOfOperatorConversion()).add((Object)new ArrayOrdinalOfOperatorConversion()).add((Object)new ArrayQuantileOperatorConversion()).add((Object)new ArraySliceOperatorConversion()).add((Object)new ArrayToStringOperatorConversion()).add((Object)new StringToArrayOperatorConversion()).add((Object)new ArrayToMultiValueStringOperatorConversion()).add((Object)new ScalarInArrayOperatorConversion()).build();
    private static final List<SqlOperatorConversion> MULTIVALUE_STRING_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new MultiValueStringOperatorConversions.Append()).add((Object)new MultiValueStringOperatorConversions.Prepend()).add((Object)new MultiValueStringOperatorConversions.Concat()).add((Object)MultiValueStringOperatorConversions.CONTAINS).add((Object)MultiValueStringOperatorConversions.OVERLAP).add((Object)new MultiValueStringOperatorConversions.Length()).add((Object)new MultiValueStringOperatorConversions.Offset()).add((Object)new MultiValueStringOperatorConversions.Ordinal()).add((Object)new MultiValueStringOperatorConversions.OffsetOf()).add((Object)new MultiValueStringOperatorConversions.OrdinalOf()).add((Object)new MultiValueStringOperatorConversions.Slice()).add((Object)new MultiValueStringOperatorConversions.MultiStringToString()).add((Object)new MultiValueStringOperatorConversions.StringToMultiString()).add((Object)new MultiValueStringOperatorConversions.FilterOnly()).add((Object)new MultiValueStringOperatorConversions.FilterNone()).add((Object)new MultiValueStringOperatorConversions.RegexFilter()).add((Object)new MultiValueStringOperatorConversions.PrefixFilter()).add((Object)new MultiValueStringToArrayOperatorConversion()).build();
    private static final List<SqlOperatorConversion> REDUCTION_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new GreatestOperatorConversion()).add((Object)new LeastOperatorConversion()).build();
    private static final List<SqlOperatorConversion> IPV4ADDRESS_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new IPv4AddressMatchOperatorConversion()).add((Object)new IPv4AddressParseOperatorConversion()).add((Object)new IPv4AddressStringifyOperatorConversion()).build();
    private static final List<SqlOperatorConversion> IPV6ADDRESS_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new IPv6AddressMatchOperatorConversion()).build();
    private static final List<SqlOperatorConversion> FORMAT_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT).add((Object)HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT).add((Object)HumanReadableFormatOperatorConversion.DECIMAL_FORMAT).build();
    private static final List<SqlOperatorConversion> CUSTOM_MATH_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new SafeDivideOperatorConversion()).build();
    private static final List<SqlOperatorConversion> BITWISE_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)OperatorConversions.druidBinaryLongFn("BITWISE_AND", "bitwiseAnd")).add((Object)OperatorConversions.druidUnaryLongFn("BITWISE_COMPLEMENT", "bitwiseComplement")).add((Object)OperatorConversions.druidBinaryLongFn("BITWISE_OR", "bitwiseOr")).add((Object)OperatorConversions.druidBinaryLongFn("BITWISE_SHIFT_LEFT", "bitwiseShiftLeft")).add((Object)OperatorConversions.druidBinaryLongFn("BITWISE_SHIFT_RIGHT", "bitwiseShiftRight")).add((Object)OperatorConversions.druidBinaryLongFn("BITWISE_XOR", "bitwiseXor")).add((Object)OperatorConversions.druidUnaryLongFn("BITWISE_CONVERT_DOUBLE_TO_LONG_BITS", "bitwiseConvertDoubleToLongBits")).add((Object)OperatorConversions.druidUnaryDoubleFn("BITWISE_CONVERT_LONG_BITS_TO_DOUBLE", "bitwiseConvertLongBitsToDouble")).build();
    private static final List<SqlOperatorConversion> NESTED_DATA_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new NestedDataOperatorConversions.JsonKeysOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonPathsOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonQueryOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonQueryArrayOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueAnyOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueBigintOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueDoubleOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueVarcharOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueReturningArrayBigIntOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueReturningArrayDoubleOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonValueReturningArrayVarcharOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonObjectOperatorConversion()).add((Object)new NestedDataOperatorConversions.JsonMergeOperatorConversion()).add((Object)new NestedDataOperatorConversions.ToJsonStringOperatorConversion()).add((Object)new NestedDataOperatorConversions.ParseJsonOperatorConversion()).add((Object)new NestedDataOperatorConversions.TryParseJsonOperatorConversion()).build();
    public static final DirectOperatorConversion ROUND_OPERATOR_CONVERSION = new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ROUND, "round");
    private static final List<SqlOperatorConversion> STANDARD_OPERATOR_CONVERSIONS = ImmutableList.builder().add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ABS, "abs")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CASE, "case_searched")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, "strlen")).add((Object)CHARACTER_LENGTH_CONVERSION).add((Object)new AliasedOperatorConversion(CHARACTER_LENGTH_CONVERSION, "LENGTH")).add((Object)new AliasedOperatorConversion(CHARACTER_LENGTH_CONVERSION, "STRLEN")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CONCAT, "concat")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.EXP, "exp")).add((Object)new DivOperatorConversion()).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, "div")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LN, "log")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LOWER, "lower")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LOG10, "log10")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.POWER, "pow")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.REPLACE, "replace")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.SQRT, "sqrt")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.UPPER, "upper")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.PI, "pi")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.SIN, "sin")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.COS, "cos")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.TAN, "tan")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.COT, "cot")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ASIN, "asin")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ACOS, "acos")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ATAN, "atan")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ATAN2, "atan2")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.RADIANS, "toRadians")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.DEGREES, "toDegrees")).add((Object)new UnaryPrefixOperatorConversion((SqlOperator)SqlStdOperatorTable.NOT, "!")).add((Object)new UnaryPrefixOperatorConversion((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, "-")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NULL, "isnull")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, "notnull")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, "isdistinctfrom")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, "notdistinctfrom")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_FALSE, "isfalse")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_TRUE, "istrue")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, "notfalse")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, "nottrue")).add((Object)new CoalesceOperatorConversion(SqlStdOperatorTable.COALESCE)).add((Object)new CoalesceOperatorConversion((SqlFunction)SqlLibraryOperators.NVL)).add((Object)new CoalesceOperatorConversion(SqlLibraryOperators.IFNULL)).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MULTIPLY, "*")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MOD, "%")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.DIVIDE, "/")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.PLUS, "+")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MINUS, "-")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.EQUALS, "==")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "!=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.GREATER_THAN, ">")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ">=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.LESS_THAN, "<")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "<=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.AND, "&&")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.OR, "||")).add((Object)new SearchOperatorConversion()).add((Object)ROUND_OPERATOR_CONVERSION).addAll(TIME_OPERATOR_CONVERSIONS).addAll(STRING_OPERATOR_CONVERSIONS).addAll(VALUE_COERCION_OPERATOR_CONVERSIONS).addAll(ARRAY_OPERATOR_CONVERSIONS).addAll(MULTIVALUE_STRING_OPERATOR_CONVERSIONS).addAll(REDUCTION_OPERATOR_CONVERSIONS).addAll(IPV4ADDRESS_OPERATOR_CONVERSIONS).addAll(IPV6ADDRESS_OPERATOR_CONVERSIONS).addAll(FORMAT_OPERATOR_CONVERSIONS).addAll(BITWISE_OPERATOR_CONVERSIONS).addAll(CUSTOM_MATH_OPERATOR_CONVERSIONS).addAll(NESTED_DATA_OPERATOR_CONVERSIONS).add((Object)TableAppendMacro.OPERATOR_CONVERSION).build();
    private static final Map<OperatorKey, SqlOperator> CONVERTLET_OPERATORS = DruidConvertletTable.knownOperators().stream().collect(Collectors.toMap(OperatorKey::of, Function.identity()));
    private final Map<OperatorKey, SqlAggregator> aggregators = new HashMap<OperatorKey, SqlAggregator>();
    private final Map<OperatorKey, SqlOperatorConversion> operatorConversions = new HashMap<OperatorKey, SqlOperatorConversion>();

    @Inject
    public DruidOperatorTable(Set<SqlAggregator> aggregators, Set<SqlOperatorConversion> operatorConversions) {
        OperatorKey operatorKey;
        for (SqlAggregator aggregator : aggregators) {
            operatorKey = OperatorKey.of((SqlOperator)aggregator.calciteFunction());
            if (this.aggregators.put(operatorKey, aggregator) == null) continue;
            throw new ISE("Cannot have two operators with key [%s]", new Object[]{operatorKey});
        }
        for (SqlAggregator aggregator : STANDARD_AGGREGATORS) {
            operatorKey = OperatorKey.of((SqlOperator)aggregator.calciteFunction());
            this.aggregators.putIfAbsent(operatorKey, aggregator);
        }
        for (SqlOperatorConversion operatorConversion : operatorConversions) {
            operatorKey = OperatorKey.of(operatorConversion.calciteOperator());
            if (!this.aggregators.containsKey(operatorKey) && this.operatorConversions.put(operatorKey, operatorConversion) == null) continue;
            throw new ISE("Cannot have two operators with key [%s]", new Object[]{operatorKey});
        }
        for (SqlOperatorConversion operatorConversion : STANDARD_OPERATOR_CONVERSIONS) {
            operatorKey = OperatorKey.of(operatorConversion.calciteOperator());
            if (this.aggregators.containsKey(operatorKey)) continue;
            this.operatorConversions.putIfAbsent(operatorKey, operatorConversion);
        }
    }

    @Nullable
    public SqlAggregator lookupAggregator(SqlAggFunction aggFunction) {
        return this.aggregators.get(OperatorKey.of((SqlOperator)aggFunction));
    }

    @Nullable
    public SqlOperatorConversion lookupOperatorConversion(SqlOperator operator) {
        return this.operatorConversions.get(OperatorKey.of(operator));
    }

    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        SqlOperator convertletOperator;
        SqlOperatorConversion operatorConversion;
        if (opName == null || opName.names.size() != 1) {
            return;
        }
        OperatorKey operatorKey = OperatorKey.of(opName.getSimple(), syntax);
        SqlAggregator aggregator = this.aggregators.get(operatorKey);
        if (aggregator != null) {
            operatorList.add((SqlOperator)aggregator.calciteFunction());
        }
        if ((operatorConversion = this.operatorConversions.get(operatorKey)) != null) {
            operatorList.add(operatorConversion.calciteOperator());
        }
        if ((convertletOperator = CONVERTLET_OPERATORS.get(operatorKey)) != null) {
            operatorList.add(convertletOperator);
        }
    }

    public List<SqlOperator> getOperatorList() {
        ArrayList<SqlOperator> retVal = new ArrayList<SqlOperator>();
        for (SqlAggregator aggregator : this.aggregators.values()) {
            retVal.add((SqlOperator)aggregator.calciteFunction());
        }
        for (SqlOperatorConversion operatorConversion : this.operatorConversions.values()) {
            retVal.add(operatorConversion.calciteOperator());
        }
        retVal.addAll(DruidConvertletTable.knownOperators());
        return retVal;
    }

    public static boolean isFunctionSyntax(SqlSyntax syntax) {
        return syntax != SqlSyntax.PREFIX && syntax != SqlSyntax.BINARY && syntax != SqlSyntax.POSTFIX;
    }

    private static SqlSyntax normalizeSyntax(SqlSyntax syntax) {
        if (!DruidOperatorTable.isFunctionSyntax(syntax)) {
            return syntax;
        }
        return SqlSyntax.FUNCTION;
    }

    private static class OperatorKey {
        private final String name;
        private final SqlSyntax syntax;

        OperatorKey(String name, SqlSyntax syntax) {
            this.name = StringUtils.toLowerCase((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
            this.syntax = DruidOperatorTable.normalizeSyntax((SqlSyntax)Preconditions.checkNotNull((Object)syntax, (Object)"syntax"));
        }

        public static OperatorKey of(String name, SqlSyntax syntax) {
            return new OperatorKey(name, syntax);
        }

        public static OperatorKey of(SqlOperator operator) {
            return new OperatorKey(operator.getName(), operator.getSyntax());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorKey that = (OperatorKey)o;
            return Objects.equals(this.name, that.name) && this.syntax == that.syntax;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.syntax);
        }

        public String toString() {
            return "OperatorKey{name='" + this.name + "', syntax=" + this.syntax + "}";
        }
    }
}

