/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeMacHostsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeMacHostsRequestMarshaller
implements Marshaller<Request<DescribeMacHostsRequest>, DescribeMacHostsRequest> {
    public Request<DescribeMacHostsRequest> marshall(DescribeMacHostsRequest describeMacHostsRequest) {
        SdkInternalList describeMacHostsRequestHostIdsList;
        if (describeMacHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMacHostsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeMacHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeMacHostsRequestFiltersList = (SdkInternalList)describeMacHostsRequest.getFilters();
        if (!describeMacHostsRequestFiltersList.isEmpty() || !describeMacHostsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeMacHostsRequestFiltersListValue : describeMacHostsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeMacHostsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeMacHostsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeMacHostsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeMacHostsRequestHostIdsList = (SdkInternalList)describeMacHostsRequest.getHostIds()).isEmpty() || !describeMacHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String describeMacHostsRequestHostIdsListValue : describeMacHostsRequestHostIdsList) {
                if (describeMacHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)describeMacHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (describeMacHostsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeMacHostsRequest.getMaxResults()));
        }
        if (describeMacHostsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeMacHostsRequest.getNextToken()));
        }
        return request;
    }
}

