/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;

public class SparseStripedReadablePartitions
implements ReadablePartitions {
    private final int stageNumber;
    private final IntSortedSet workers;
    private final IntSortedSet partitionNumbers;

    public SparseStripedReadablePartitions(int stageNumber, IntSortedSet workers, IntSortedSet partitionNumbers) {
        this.stageNumber = stageNumber;
        this.workers = workers;
        this.partitionNumbers = partitionNumbers;
    }

    @JsonCreator
    private SparseStripedReadablePartitions(@JsonProperty(value="stageNumber") int stageNumber, @JsonProperty(value="workers") Set<Integer> workers, @JsonProperty(value="partitionNumbers") Set<Integer> partitionNumbers) {
        this(stageNumber, (IntSortedSet)new IntAVLTreeSet(workers), (IntSortedSet)new IntAVLTreeSet(partitionNumbers));
    }

    @Override
    public Iterator<ReadablePartition> iterator() {
        return Iterators.transform((Iterator)this.partitionNumbers.iterator(), partitionNumber -> ReadablePartition.striped(this.stageNumber, this.workers, (int)partitionNumber));
    }

    @Override
    public List<ReadablePartitions> split(int maxNumSplits) {
        ArrayList<ReadablePartitions> retVal = new ArrayList<ReadablePartitions>();
        for (List entries : SlicerUtils.makeSlicesStatic(this.partitionNumbers.iterator(), maxNumSplits)) {
            if (entries.isEmpty()) continue;
            retVal.add(new SparseStripedReadablePartitions(this.stageNumber, this.workers, (IntSortedSet)new IntAVLTreeSet(entries)));
        }
        return retVal;
    }

    @JsonProperty
    int getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty
    IntSortedSet getWorkers() {
        return this.workers;
    }

    @JsonProperty
    IntSortedSet getPartitionNumbers() {
        return this.partitionNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseStripedReadablePartitions that = (SparseStripedReadablePartitions)o;
        return this.stageNumber == that.stageNumber && Objects.equals(this.workers, that.workers) && Objects.equals(this.partitionNumbers, that.partitionNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.stageNumber, this.workers, this.partitionNumbers);
    }

    public String toString() {
        return "StripedReadablePartitions{stageNumber=" + this.stageNumber + ", workers=" + this.workers + ", partitionNumbers=" + this.partitionNumbers + "}";
    }
}

