/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.write.InvalidFieldException;
import org.apache.druid.frame.write.InvalidNullByteException;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.indexing.common.task.batch.TooManyBucketsException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.CannotParseExternalDataFault;
import org.apache.druid.msq.indexing.error.ColumnTypeNotSupportedFault;
import org.apache.druid.msq.indexing.error.InvalidFieldFault;
import org.apache.druid.msq.indexing.error.InvalidNullByteFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.QueryRuntimeFault;
import org.apache.druid.msq.indexing.error.RowTooLargeFault;
import org.apache.druid.msq.indexing.error.TooManyBucketsFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.query.groupby.epinephelinae.UnexpectedMultiValueDimensionException;
import org.apache.druid.sql.calcite.planner.ColumnMappings;

public class MSQErrorReport {
    private final String taskId;
    @Nullable
    private final String host;
    @Nullable
    private final Integer stageNumber;
    private final MSQFault error;
    @Nullable
    private final String exceptionStackTrace;

    @JsonCreator
    MSQErrorReport(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="host") @Nullable String host, @JsonProperty(value="stageNumber") @Nullable Integer stageNumber, @JsonProperty(value="error") MSQFault fault, @JsonProperty(value="exceptionStackTrace") @Nullable String exceptionStackTrace) {
        this.taskId = (String)Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.host = host;
        this.stageNumber = stageNumber;
        this.error = (MSQFault)Preconditions.checkNotNull((Object)fault, (Object)"error");
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public static MSQErrorReport fromFault(String taskId, @Nullable String host, @Nullable Integer stageNumber, MSQFault fault) {
        return new MSQErrorReport(taskId, host, stageNumber, fault, null);
    }

    public static MSQErrorReport fromException(String taskId, @Nullable String host, @Nullable Integer stageNumber, Throwable e) {
        return MSQErrorReport.fromException(taskId, host, stageNumber, e, null);
    }

    public static MSQErrorReport fromException(String taskId, @Nullable String host, @Nullable Integer stageNumber, Throwable e, @Nullable ColumnMappings columnMappings) {
        return new MSQErrorReport(taskId, host, stageNumber, MSQErrorReport.getFaultFromException(e, columnMappings), Throwables.getStackTraceAsString((Throwable)e));
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHost() {
        return this.host;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty(value="error")
    public MSQFault getFault() {
        return this.error;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public DruidException toDruidException() {
        DruidException druidException = this.error.toDruidException().withContext("taskId", (Object)this.taskId);
        if (this.host != null) {
            druidException.withContext("host", (Object)this.host);
        }
        if (this.stageNumber != null) {
            druidException.withContext("stageNumber", (Object)this.stageNumber);
        }
        if (this.exceptionStackTrace != null) {
            druidException.withContext("exceptionStackTrace", (Object)this.exceptionStackTrace);
        }
        return druidException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQErrorReport that = (MSQErrorReport)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.host, that.host) && Objects.equals(this.stageNumber, that.stageNumber) && Objects.equals(this.error, that.error) && Objects.equals(this.exceptionStackTrace, that.exceptionStackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.host, this.error, this.exceptionStackTrace);
    }

    public String toString() {
        return "MSQErrorReport{taskId='" + this.taskId + "', host='" + this.host + "', stageNumber=" + this.stageNumber + ", error=" + this.error + ", exceptionStackTrace='" + this.exceptionStackTrace + "'}";
    }

    public static MSQFault getFaultFromException(@Nullable Throwable e) {
        return MSQErrorReport.getFaultFromException(e, null);
    }

    public static MSQFault getFaultFromException(@Nullable Throwable e, @Nullable ColumnMappings columnMappings) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (cause instanceof MSQException) {
                return ((MSQException)cause).getFault();
            }
            if (cause instanceof ParseException) {
                return new CannotParseExternalDataFault(cause.getMessage());
            }
            if (cause instanceof UnsupportedColumnTypeException) {
                UnsupportedColumnTypeException unsupportedColumnTypeException = (UnsupportedColumnTypeException)cause;
                return new ColumnTypeNotSupportedFault(unsupportedColumnTypeException.getColumnName(), unsupportedColumnTypeException.getColumnType());
            }
            if (cause instanceof TooManyBucketsException) {
                return new TooManyBucketsFault(((TooManyBucketsException)cause).getMaxBuckets());
            }
            if (cause instanceof FrameRowTooLargeException) {
                return new RowTooLargeFault(((FrameRowTooLargeException)cause).getMaxFrameSize());
            }
            if (cause instanceof InvalidNullByteException) {
                IntList outputColumnsForQueryColumn;
                InvalidNullByteException invalidNullByteException = (InvalidNullByteException)cause;
                String columnName = invalidNullByteException.getColumn();
                if (columnMappings != null && (outputColumnsForQueryColumn = columnMappings.getOutputColumnsForQueryColumn(columnName)).size() >= 1) {
                    int outputColumn = outputColumnsForQueryColumn.getInt(0);
                    columnName = columnMappings.getOutputColumnName(outputColumn);
                }
                return new InvalidNullByteFault(invalidNullByteException.getSource(), invalidNullByteException.getRowNumber(), columnName, invalidNullByteException.getValue(), invalidNullByteException.getPosition());
            }
            if (cause instanceof InvalidFieldException) {
                IntList outputColumnsForQueryColumn;
                InvalidFieldException invalidFieldException = (InvalidFieldException)cause;
                String columnName = invalidFieldException.getColumn();
                if (columnMappings != null && !(outputColumnsForQueryColumn = columnMappings.getOutputColumnsForQueryColumn(columnName)).isEmpty()) {
                    int outputColumn = outputColumnsForQueryColumn.getInt(0);
                    columnName = columnMappings.getOutputColumnName(outputColumn);
                }
                return new InvalidFieldFault(invalidFieldException.getSource(), columnName, invalidFieldException.getRowNumber(), invalidFieldException.getErrorMsg(), invalidFieldException.getMessage());
            }
            if (cause instanceof UnexpectedMultiValueDimensionException) {
                return new QueryRuntimeFault(StringUtils.format((String)"Column [%s] is a multi-value string. Please wrap the column using MV_TO_ARRAY() to proceed further.", (Object[])new Object[]{((UnexpectedMultiValueDimensionException)cause).getDimensionName()}), cause.getMessage());
            }
            if (cause instanceof InterruptedException) {
                return CanceledFault.unknown();
            }
            if (!cause.getClass().getPackage().getName().startsWith("org.apache.druid.query")) continue;
            return new QueryRuntimeFault(e.getMessage(), null);
        }
        return UnknownFault.forException(e);
    }
}

