/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.indexing.error.MSQErrorReport;

public class WorkerWarning
implements ControllerMessage {
    private final String queryId;
    private final List<MSQErrorReport> errorWrappers;

    @JsonCreator
    public WorkerWarning(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="errors") List<MSQErrorReport> errorWrappers) {
        this.queryId = (String)Preconditions.checkNotNull((Object)queryId, (Object)"queryId");
        this.errorWrappers = (List)Preconditions.checkNotNull(errorWrappers, (Object)"error");
    }

    @Override
    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty(value="errors")
    public List<MSQErrorReport> getErrorWrappers() {
        return this.errorWrappers;
    }

    @Override
    public void handle(Controller controller) {
        controller.workerWarning(this.errorWrappers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerWarning that = (WorkerWarning)o;
        return Objects.equals(this.queryId, that.queryId) && Objects.equals(this.errorWrappers, that.errorWrappers);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.errorWrappers);
    }

    public String toString() {
        return "WorkerWarning{queryId='" + this.queryId + "', errorWrappers=" + this.errorWrappers + "}";
    }
}

