/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class ExpressionVirtualColumn
implements VirtualColumn {
    private static final Logger log = new Logger(ExpressionVirtualColumn.class);
    private final String name;
    private final Expression expression;
    private final Supplier<Expr.BindingAnalysis> expressionAnalysis;
    private final Supplier<byte[]> cacheKey;

    @JsonCreator
    public ExpressionVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="outputType") @Nullable ColumnType outputType, @JacksonInject ExprMacroTable macroTable) {
        this(name, expression, outputType, Parser.lazyParse(expression, macroTable));
    }

    public ExpressionVirtualColumn(String name, String expression, Expr parsedExpression, @Nullable ColumnType outputType) {
        this(name, expression, outputType, (Supplier<Expr>)((Supplier)() -> parsedExpression));
    }

    public ExpressionVirtualColumn(String name, Expr parsedExpression, @Nullable ColumnType outputType) {
        this(name, parsedExpression.stringify(), outputType, (Supplier<Expr>)((Supplier)() -> parsedExpression));
    }

    private ExpressionVirtualColumn(String name, String expression, @Nullable ColumnType outputType, Supplier<Expr> parsedExpression) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.expression = new Expression((String)Preconditions.checkNotNull((Object)expression, (Object)"expression"), parsedExpression, outputType);
        this.expressionAnalysis = Suppliers.memoize(() -> ((Expr)parsedExpression.get()).analyzeInputs());
        this.cacheKey = this.makeCacheKeySupplier();
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression.expressionString;
    }

    @Nullable
    @JsonProperty
    public ColumnType getOutputType() {
        return this.expression.outputType;
    }

    @JsonIgnore
    @VisibleForTesting
    public Supplier<Expr> getParsedExpression() {
        return this.expression.parsed;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory columnSelectorFactory) {
        if (this.isDirectAccess(columnSelectorFactory)) {
            return columnSelectorFactory.makeDimensionSelector(dimensionSpec.withDimension(((Expr)this.expression.parsed.get()).getBindingIfIdentifier()));
        }
        return dimensionSpec.decorate(ExpressionSelectors.makeDimensionSelector(columnSelectorFactory, (Expr)this.expression.parsed.get(), dimensionSpec.getExtractionFn()));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeColumnValueSelector(((Expr)this.expression.parsed.get()).getBindingIfIdentifier());
        }
        ColumnCapabilities capabilities = this.capabilities(factory, this.name);
        if (capabilities.is(ValueType.STRING)) {
            return ExpressionSelectors.makeStringColumnValueSelector(factory, (Expr)this.expression.parsed.get());
        }
        return ExpressionSelectors.makeColumnValueSelector(factory, (Expr)this.expression.parsed.get());
    }

    @Override
    public boolean canVectorize(ColumnInspector inspector) {
        if (this.isDirectAccess(inspector)) {
            return true;
        }
        ExpressionPlan plan = ExpressionPlanner.plan(inspector, (Expr)this.expression.parsed.get());
        return plan.is(ExpressionPlan.Trait.VECTORIZABLE);
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeSingleValueDimensionSelector(dimensionSpec.withDimension(((Expr)this.expression.parsed.get()).getBindingIfIdentifier()));
        }
        return ExpressionVectorSelectors.makeSingleValueDimensionVectorSelector(factory, (Expr)this.expression.parsed.get());
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeValueSelector(((Expr)this.expression.parsed.get()).getBindingIfIdentifier());
        }
        return ExpressionVectorSelectors.makeVectorValueSelector(factory, (Expr)this.expression.parsed.get());
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeObjectSelector(((Expr)this.expression.parsed.get()).getBindingIfIdentifier());
        }
        return ExpressionVectorSelectors.makeVectorObjectSelector(factory, (Expr)this.expression.parsed.get(), this.expression.outputType);
    }

    @Override
    @Nullable
    public GroupByVectorColumnSelector makeGroupByVectorColumnSelector(String columnName, VectorColumnSelectorFactory factory, DeferExpressionDimensions deferExpressionDimensions) {
        if (this.isDirectAccess(factory)) {
            return factory.makeGroupByVectorColumnSelector(((Expr)this.expression.parsed.get()).getBindingIfIdentifier(), deferExpressionDimensions);
        }
        return ExpressionVectorSelectors.makeGroupByVectorColumnSelector(factory, (Expr)this.expression.parsed.get(), deferExpressionDimensions);
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnIndexSelector columnIndexSelector) {
        if (this.isDirectAccess(columnIndexSelector)) {
            return columnIndexSelector.getIndexSupplier(((Expr)this.expression.parsed.get()).getBindingIfIdentifier());
        }
        return ((Expr)this.getParsedExpression().get()).asColumnIndexSupplier(columnIndexSelector, this.expression.outputType);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        ColumnType outputType = this.expression.outputType;
        if (ExpressionProcessing.processArraysAsMultiValueStrings() && outputType != null && outputType.isArray()) {
            return new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(true);
        }
        return new ColumnCapabilitiesImpl().setType(outputType == null ? ColumnType.FLOAT : outputType);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        if (this.isDirectAccess(inspector)) {
            return inspector.getColumnCapabilities(((Expr)this.expression.parsed.get()).getBindingIfIdentifier());
        }
        ColumnType outputType = this.expression.outputType;
        ExpressionPlan plan = ExpressionPlanner.plan(inspector, (Expr)this.expression.parsed.get());
        ColumnCapabilities inferred = plan.inferColumnCapabilities(outputType);
        if (inferred != null) {
            if (outputType != null && inferred.getType() != outputType.getType()) {
                if (!inferred.isNumeric() && !outputType.isNumeric()) {
                    log.warn("Projected output type %s of expression %s does not match provided type %s", inferred.asTypeString(), this.expression.expressionString, outputType);
                } else {
                    log.debug("Projected output type %s of expression %s does not match provided type %s", inferred.asTypeString(), this.expression.expressionString, outputType);
                }
            }
            return inferred;
        }
        return this.capabilities(columnName);
    }

    @Override
    public List<String> requiredColumns() {
        return ((Expr.BindingAnalysis)this.expressionAnalysis.get()).getRequiredBindingsList();
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    @Override
    @Nullable
    public VirtualColumn.EquivalenceKey getEquivalanceKey() {
        return this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionVirtualColumn that = (ExpressionVirtualColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression.expressionString, that.expression.expressionString) && Objects.equals(this.expression.outputType, that.expression.outputType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression.expressionString, this.expression.outputType);
    }

    public String toString() {
        return "ExpressionVirtualColumn{name='" + this.name + "', expression=" + this.expression + "}";
    }

    private boolean isDirectAccess(ColumnInspector inspector) {
        if (((Expr)this.expression.parsed.get()).isIdentifier()) {
            ColumnCapabilities baseCapabilities = inspector.getColumnCapabilities(((Expr)this.expression.parsed.get()).getBindingIfIdentifier());
            if (this.expression.outputType == null) {
                return true;
            }
            if (baseCapabilities != null && this.expression.outputType.equals(baseCapabilities.toColumnType())) {
                return true;
            }
        }
        return false;
    }

    private Supplier<byte[]> makeCacheKeySupplier() {
        return Suppliers.memoize(() -> {
            CacheKeyBuilder builder = new CacheKeyBuilder(1).appendString(this.name).appendCacheable((Cacheable)this.expression.parsed.get());
            if (this.expression.outputType != null) {
                builder.appendString(this.expression.outputType.toString());
            }
            return builder.build();
        });
    }

    private static final class Expression
    implements VirtualColumn.EquivalenceKey {
        private final String expressionString;
        private final Supplier<Expr> parsed;
        @Nullable
        private final ColumnType outputType;

        private Expression(String expression, Supplier<Expr> parsedExpression, @Nullable ColumnType outputType) {
            this.expressionString = expression;
            this.parsed = parsedExpression;
            this.outputType = outputType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Expression that = (Expression)o;
            return Objects.equals(((Expr)this.parsed.get()).stringify(), ((Expr)that.parsed.get()).stringify()) && Objects.equals(this.outputType, that.outputType);
        }

        public int hashCode() {
            return Objects.hash(((Expr)this.parsed.get()).stringify(), this.outputType);
        }

        public String toString() {
            return "Expression{expression='" + ((Expr)this.parsed.get()).stringify() + "', outputType=" + this.outputType + "}";
        }
    }
}

