/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.shim.ShimCursor;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ShimObjectColumnValueSelector
extends ObjectColumnSelector<Object> {
    private final ShimCursor cursor;
    private final ReadableVectorInspector vectorInspector;
    private final VectorObjectSelector vectorSelector;
    private Object[] objectVector;
    private int objectId = -1;

    public ShimObjectColumnValueSelector(ShimCursor cursor, VectorObjectSelector vectorSelector) {
        this.cursor = cursor;
        this.vectorInspector = cursor.vectorColumnSelectorFactory.getReadableVectorInspector();
        this.vectorSelector = vectorSelector;
    }

    @Override
    @Nullable
    public Object getObject() {
        this.populateObjectVector();
        return this.objectVector[this.cursor.currentIndexInVector];
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    private void populateObjectVector() {
        int id = this.vectorInspector.getId();
        if (id != this.objectId) {
            this.objectVector = this.vectorSelector.getObjectVector();
            this.objectId = id;
        }
    }
}

