/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class ConstantPostAggregator
implements PostAggregator {
    private final String name;
    private final Number constantValue;

    @JsonCreator
    public ConstantPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="value") Number constantValue) {
        this.name = name;
        this.constantValue = (Number)Preconditions.checkNotNull((Object)constantValue, (Object)"Constant value cannot be null");
    }

    @Override
    public Set<String> getDependentFields() {
        return new HashSet<String>();
    }

    @Override
    public Comparator getComparator() {
        return Comparators.alwaysEqual();
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        return this.constantValue;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getType(ColumnInspector signature) {
        return this.constantValue instanceof Long ? ColumnType.LONG : ColumnType.DOUBLE;
    }

    @Override
    public ConstantPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty(value="value")
    public Number getConstantValue() {
        return this.constantValue;
    }

    public String toString() {
        return "ConstantPostAggregator{name='" + this.name + "', constantValue=" + this.constantValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantPostAggregator that = (ConstantPostAggregator)o;
        if (this.constantValue.doubleValue() != that.constantValue.doubleValue()) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.constantValue.hashCode();
        return result;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(1).appendDouble(this.constantValue.doubleValue()).build();
    }
}

