/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.annotations.EverythingIsNonnullByDefault;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.constant.LongConstantAggregator;
import org.apache.druid.query.aggregation.constant.LongConstantBufferAggregator;
import org.apache.druid.query.aggregation.constant.LongConstantVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.utils.CollectionUtils;

@EverythingIsNonnullByDefault
public class GroupingAggregatorFactory
extends AggregatorFactory {
    private static final Comparator<Long> VALUE_COMPARATOR = Long::compare;
    private final String name;
    private final List<String> groupings;
    private final long value;
    @Nullable
    private final Set<String> keyDimensions;

    @JsonCreator
    public GroupingAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="groupings") List<String> groupings) {
        this(name, groupings, null);
    }

    @VisibleForTesting
    GroupingAggregatorFactory(String name, List<String> groupings, @Nullable Set<String> keyDimensions) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkArgument((!CollectionUtils.isNullOrEmpty(groupings) ? 1 : 0) != 0, (Object)"Must have a non-empty grouping dimensions");
        Preconditions.checkArgument((groupings.size() < 64 ? 1 : 0) != 0, (String)"Number of dimensions %s is more than supported %s", (int)groupings.size(), (int)63);
        Preconditions.checkArgument((groupings.stream().distinct().count() == (long)groupings.size() ? 1 : 0) != 0, (Object)"Encountered same dimension more than once in groupings");
        this.name = name;
        this.groupings = groupings;
        this.keyDimensions = keyDimensions;
        this.value = this.groupingId(groupings, keyDimensions);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new LongConstantAggregator(this.value);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new LongConstantBufferAggregator(this.value);
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return new LongConstantVectorAggregator(this.value);
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public GroupingAggregatorFactory withKeyDimensions(Set<String> newKeyDimensions) {
        return new GroupingAggregatorFactory(this.name, this.groupings, newKeyDimensions);
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @JsonProperty
    public List<String> getGroupings() {
        return this.groupings;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (null == lhs) {
            return rhs;
        }
        return lhs;
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new GroupingAggregatorFactory(this.name, this.groupings, this.keyDimensions);
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.emptyList();
    }

    @Override
    public ColumnType getIntermediateType() {
        return ColumnType.LONG;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.LONG;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new GroupingAggregatorFactory(newName, this.groupings, this.keyDimensions);
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder keyBuilder = new CacheKeyBuilder(70).appendStrings(this.groupings);
        if (null != this.keyDimensions) {
            keyBuilder.appendStrings(this.keyDimensions);
        }
        return keyBuilder.build();
    }

    private long groupingId(List<String> groupings, @Nullable Set<String> keyDimensions) {
        long temp = 0L;
        for (String groupingDimension : groupings) {
            temp <<= 1;
            if (this.isDimensionIncluded(groupingDimension, keyDimensions)) continue;
            temp |= 1L;
        }
        return temp;
    }

    private boolean isDimensionIncluded(String dimToCheck, @Nullable Set<String> keyDimensions) {
        if (null == keyDimensions) {
            return true;
        }
        return keyDimensions.contains(dimToCheck);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingAggregatorFactory factory = (GroupingAggregatorFactory)o;
        return this.name.equals(factory.name) && this.groupings.equals(factory.groupings) && Objects.equals(this.keyDimensions, factory.keyDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.groupings, this.keyDimensions);
    }

    public String toString() {
        return "GroupingAggregatorFactory{name='" + this.name + "', groupings=" + this.groupings + ", keyDimensions=" + this.keyDimensions + "}";
    }
}

