/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.Query;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.planning.JoinDataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinableClauses;
import org.apache.druid.segment.join.filter.rewrite.JoinFilterRewriteConfig;
import org.apache.druid.utils.CloseableUtils;

public class JoinDataSource
implements DataSource {
    private final DataSource left;
    private final DataSource right;
    private final String rightPrefix;
    private final JoinConditionAnalysis conditionAnalysis;
    private final JoinType joinType;
    @Nullable
    private final DimFilter leftFilter;
    @Nullable
    private final JoinableFactoryWrapper joinableFactoryWrapper;
    private final JoinAlgorithm joinAlgorithm;
    private static final Logger log = new Logger(JoinDataSource.class);

    private JoinDataSource(DataSource left, DataSource right, String rightPrefix, JoinConditionAnalysis conditionAnalysis, JoinType joinType, @Nullable DimFilter leftFilter, @Nullable JoinableFactoryWrapper joinableFactoryWrapper, JoinAlgorithm joinAlgorithm) {
        this.left = (DataSource)Preconditions.checkNotNull((Object)left, (Object)"left");
        this.right = (DataSource)Preconditions.checkNotNull((Object)right, (Object)"right");
        this.rightPrefix = JoinPrefixUtils.validatePrefix(rightPrefix);
        this.conditionAnalysis = (JoinConditionAnalysis)Preconditions.checkNotNull((Object)conditionAnalysis, (Object)"conditionAnalysis");
        this.joinType = (JoinType)Preconditions.checkNotNull((Object)joinType, (Object)"joinType");
        this.leftFilter = JoinDataSource.validateLeftFilter(left, leftFilter);
        this.joinableFactoryWrapper = joinableFactoryWrapper;
        this.joinAlgorithm = JoinAlgorithm.BROADCAST.equals((Object)joinAlgorithm) ? null : joinAlgorithm;
    }

    @JsonCreator
    public static JoinDataSource create(@JsonProperty(value="left") DataSource left, @JsonProperty(value="right") DataSource right, @JsonProperty(value="rightPrefix") String rightPrefix, @JsonProperty(value="condition") String condition, @JsonProperty(value="joinType") JoinType joinType, @Nullable @JsonProperty(value="leftFilter") DimFilter leftFilter, @JacksonInject ExprMacroTable macroTable, @Nullable @JacksonInject JoinableFactoryWrapper joinableFactoryWrapper, @Nullable @JsonProperty(value="joinAlgorithm") JoinAlgorithm joinAlgorithm) {
        return new JoinDataSource(left, right, StringUtils.nullToEmptyNonDruidDataString(rightPrefix), JoinConditionAnalysis.forExpression((String)Preconditions.checkNotNull((Object)condition, (Object)"condition"), StringUtils.nullToEmptyNonDruidDataString(rightPrefix), macroTable), joinType, leftFilter, joinableFactoryWrapper, joinAlgorithm);
    }

    public static JoinDataSource create(DataSource left, DataSource right, String rightPrefix, JoinConditionAnalysis conditionAnalysis, JoinType joinType, DimFilter leftFilter, @Nullable JoinableFactoryWrapper joinableFactoryWrapper, @Nullable JoinAlgorithm joinAlgorithm) {
        return new JoinDataSource(left, right, rightPrefix, conditionAnalysis, joinType, leftFilter, joinableFactoryWrapper, joinAlgorithm);
    }

    @Override
    public Set<String> getTableNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.left.getTableNames());
        names.addAll(this.right.getTableNames());
        return names;
    }

    @JsonProperty
    public DataSource getLeft() {
        return this.left;
    }

    @JsonProperty
    public DataSource getRight() {
        return this.right;
    }

    @JsonProperty
    public String getRightPrefix() {
        return this.rightPrefix;
    }

    @JsonProperty
    public String getCondition() {
        return this.conditionAnalysis.getOriginalExpression();
    }

    public JoinConditionAnalysis getConditionAnalysis() {
        return this.conditionAnalysis;
    }

    @JsonProperty
    public JoinType getJoinType() {
        return this.joinType;
    }

    @JsonProperty
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DimFilter getLeftFilter() {
        return this.leftFilter;
    }

    @Nullable
    public JoinableFactoryWrapper getJoinableFactoryWrapper() {
        return this.joinableFactoryWrapper;
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != 2) {
            throw new IAE("Expected [2] children, got [%d]", children.size());
        }
        return new JoinDataSource(children.get(0), children.get(1), this.rightPrefix, this.conditionAnalysis, this.joinType, this.leftFilter, this.joinableFactoryWrapper, this.joinAlgorithm);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return this.left.isCacheable(isBroker) && this.right.isCacheable(isBroker);
    }

    @Override
    public boolean isGlobal() {
        return this.left.isGlobal() && this.right.isGlobal();
    }

    @Override
    public boolean isProcessable() {
        return this.left.isProcessable() && this.right.isGlobal();
    }

    public Set<String> getVirtualColumnCandidates() {
        return this.getConditionAnalysis().getEquiConditions().stream().filter(equality -> equality.getLeftExpr() != null).map(equality -> equality.getLeftExpr().analyzeInputs().getRequiredBindings()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder keyBuilder = new CacheKeyBuilder(1);
        keyBuilder.appendCacheable(this.leftFilter);
        keyBuilder.appendCacheable(this.conditionAnalysis);
        keyBuilder.appendCacheable(this.joinType);
        keyBuilder.appendCacheable(this.left);
        keyBuilder.appendCacheable(this.right);
        return keyBuilder.build();
    }

    @JsonProperty(value="joinAlgorithm")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private JoinAlgorithm getJoinAlgorithmForSerialization() {
        return this.joinAlgorithm;
    }

    public JoinAlgorithm getJoinAlgorithm() {
        return this.joinAlgorithm == null ? JoinAlgorithm.BROADCAST : this.joinAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinDataSource that = (JoinDataSource)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.rightPrefix, that.rightPrefix) && Objects.equals(this.conditionAnalysis, that.conditionAnalysis) && Objects.equals(this.leftFilter, that.leftFilter) && this.joinAlgorithm == that.joinAlgorithm && this.joinType == that.joinType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right, this.rightPrefix, this.conditionAnalysis, this.joinType, this.leftFilter, this.joinAlgorithm});
    }

    public String toString() {
        return "JoinDataSource{left=" + this.left + ", right=" + this.right + ", rightPrefix='" + this.rightPrefix + "', condition=" + this.conditionAnalysis + ", joinType=" + this.joinType + ", leftFilter=" + this.leftFilter + ", joinAlgorithm=" + this.joinAlgorithm + "}";
    }

    @Override
    public SegmentMapFunction createSegmentMapFunction(Query query) {
        List clausesToUse;
        Filter baseFilterToUse;
        JoinDataSourceAnalysis joinAnalysis = this.getJoinAnalysisForDataSource();
        List<PreJoinableClause> clauses = joinAnalysis.getPreJoinableClauses();
        Filter baseFilter = joinAnalysis.getJoinBaseTableFilter().map(Filters::toFilter).orElse(null);
        if (clauses.isEmpty()) {
            throw DruidException.defensive("A JoinDataSource with no join clauses should not be mapped.", new Object[0]);
        }
        JoinableClauses joinableClauses = JoinableClauses.createClauses(clauses, this.joinableFactoryWrapper.getJoinableFactory());
        JoinFilterRewriteConfig filterRewriteConfig = JoinFilterRewriteConfig.forQuery(query);
        Set<String> requiredColumns = query.getRequiredColumns();
        if (requiredColumns != null && filterRewriteConfig.isEnableRewriteJoinToFilter()) {
            Pair<List<Filter>, List<JoinableClause>> conversionResult = JoinableFactoryWrapper.convertJoinsToFilters(joinableClauses.getJoinableClauses(), requiredColumns, Ints.checkedCast((long)Math.min(filterRewriteConfig.getFilterRewriteMaxSize(), Integer.MAX_VALUE)));
            baseFilterToUse = Filters.maybeAnd(Lists.newArrayList((Iterable)Iterables.concat(Collections.singleton(baseFilter), (Iterable)((Iterable)conversionResult.lhs)))).orElse(null);
            clausesToUse = (List)conversionResult.rhs;
        } else {
            baseFilterToUse = baseFilter;
            clausesToUse = joinableClauses.getJoinableClauses();
        }
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzer.computeJoinFilterPreAnalysis(new JoinFilterPreAnalysisKey(filterRewriteConfig, clausesToUse, query.getVirtualColumns(), Filters.maybeAnd(Arrays.asList(baseFilterToUse, Filters.toFilter(query.getFilter()))).orElse(null)));
        SegmentMapFunction baseMapFn = joinAnalysis.getBaseDataSource().createSegmentMapFunction(query);
        return JoinDataSource.createSegmentMapFunction(clausesToUse, baseFilterToUse, joinFilterPreAnalysis, baseMapFn);
    }

    public static SegmentMapFunction createSegmentMapFunction(List<JoinableClause> clausesToUse, Filter baseFilterToUse, JoinFilterPreAnalysis joinFilterPreAnalysis, SegmentMapFunction baseMapFn) {
        return baseSegmentReference -> {
            Optional maybeBaseSegment = (Optional)baseMapFn.apply(baseSegmentReference);
            if (maybeBaseSegment.isPresent()) {
                Segment baseSegment = (Segment)maybeBaseSegment.get();
                Closer closer = Closer.create();
                try {
                    boolean acquireFailed = false;
                    for (JoinableClause joinClause : clausesToUse) {
                        if (acquireFailed) break;
                        acquireFailed = joinClause.acquireReference().map(closeable -> {
                            closer.register(closeable);
                            return false;
                        }).orElse(true);
                    }
                    if (acquireFailed) {
                        CloseableUtils.closeAndWrapExceptions(closer);
                        CloseableUtils.closeAndWrapExceptions(baseSegment);
                        return Optional.empty();
                    }
                    return Optional.of(JoinDataSource.createHashJoinSegment(baseSegment, baseFilterToUse, clausesToUse, joinFilterPreAnalysis, closer));
                }
                catch (Throwable e) {
                    CloseableUtils.closeAndSuppressExceptions(closer, e::addSuppressed);
                    CloseableUtils.closeAndSuppressExceptions(baseSegment, e::addSuppressed);
                    log.warn(e, "Exception encountered while trying to acquire reference", new Object[0]);
                    return Optional.empty();
                }
            }
            return Optional.empty();
        };
    }

    private static Segment createHashJoinSegment(Segment sourceSegment, Filter baseFilterToUse, List<JoinableClause> clausesToUse, JoinFilterPreAnalysis joinFilterPreAnalysis, Closeable closeable) {
        if (clausesToUse.isEmpty() && baseFilterToUse == null) {
            return sourceSegment;
        }
        return new HashJoinSegment(sourceSegment, baseFilterToUse, clausesToUse, joinFilterPreAnalysis, closeable);
    }

    @VisibleForTesting
    public JoinDataSourceAnalysis getJoinAnalysisForDataSource() {
        return JoinDataSourceAnalysis.constructAnalysis(this);
    }

    private static JoinDataSourceAnalysis constructAnalysis(JoinDataSource dataSource, boolean vertexBoundary) {
        DataSource current = dataSource;
        DimFilter currentDimFilter = TrueDimFilter.instance();
        ArrayList<PreJoinableClause> preJoinableClauses = new ArrayList<PreJoinableClause>();
        while (true) {
            if (current instanceof JoinDataSource) {
                JoinDataSource joinDataSource = current;
                currentDimFilter = DimFilters.conjunction(currentDimFilter, joinDataSource.getLeftFilter());
                PreJoinableClause e = new PreJoinableClause(joinDataSource);
                preJoinableClauses.add(e);
                current = joinDataSource.getLeft();
                continue;
            }
            if (!vertexBoundary) break;
            if (current instanceof UnnestDataSource) {
                UnnestDataSource unnestDataSource = (UnnestDataSource)current;
                current = unnestDataSource.getBase();
                continue;
            }
            if (!(current instanceof FilteredDataSource)) break;
            FilteredDataSource filteredDataSource = (FilteredDataSource)current;
            current = filteredDataSource.getBase();
        }
        if (currentDimFilter == TrueDimFilter.instance()) {
            currentDimFilter = null;
        }
        Collections.reverse(preJoinableClauses);
        return new JoinDataSourceAnalysis(current, null, currentDimFilter, preJoinableClauses, null);
    }

    @Nullable
    private static DimFilter validateLeftFilter(DataSource leftDataSource, @Nullable DimFilter leftFilter) {
        if (leftFilter == null || TrueDimFilter.instance().equals(leftFilter)) {
            return null;
        }
        Preconditions.checkArgument((leftDataSource.isProcessable() && leftDataSource.getChildren().isEmpty() ? 1 : 0) != 0, (Object)"left filter is only supported if left data source is direct table access");
        return leftFilter;
    }
}

