/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Intervals {
    public static final Interval ETERNITY = Intervals.utc(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    public static final ImmutableList<Interval> ONLY_ETERNITY = ImmutableList.of((Object)ETERNITY);
    private static final DateTimeFormatter FAST_ISO_UTC_FORMATTER = ISODateTimeFormat.dateTime().withChronology((Chronology)ISOChronology.getInstanceUTC());

    public static Interval utc(long startInstant, long endInstant) {
        return new Interval(startInstant, endInstant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static Interval of(String interval) {
        try {
            return new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC());
        }
        catch (IllegalArgumentException e) {
            throw InvalidInput.exception(e, "Invalid interval[%s]: [%s]", interval, e.getMessage());
        }
    }

    public static Interval of(String format, Object ... formatArgs) {
        return Intervals.of(StringUtils.format(format, formatArgs));
    }

    public static Interval fromString(String serializedInterval) {
        Interval interval;
        if (Intervals.canDeserializeIntervalOptimallyFromString(serializedInterval) && (interval = Intervals.tryOptimizedIntervalDeserialization(serializedInterval)) != null) {
            return interval;
        }
        return Intervals.of(serializedInterval);
    }

    private static boolean canDeserializeIntervalOptimallyFromString(String serializedInterval) {
        if (serializedInterval.contains("P")) {
            return false;
        }
        int slashIndex = serializedInterval.indexOf(47);
        return slashIndex > 0 && slashIndex < serializedInterval.length() - 1;
    }

    @Nullable
    private static Interval tryOptimizedIntervalDeserialization(String serializedInterval) {
        int slashIndex = serializedInterval.indexOf(47);
        String startStr = serializedInterval.substring(0, slashIndex);
        String endStr = serializedInterval.substring(slashIndex + 1);
        try {
            long startMillis = FAST_ISO_UTC_FORMATTER.parseMillis(startStr);
            long endMillis = FAST_ISO_UTC_FORMATTER.parseMillis(endStr);
            return Intervals.utc(startMillis, endMillis);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean canCompareEndpointsAsStrings(Interval interval) {
        return DateTimes.canCompareAsString(interval.getStart()) && DateTimes.canCompareAsString(interval.getEnd());
    }

    public static boolean isEternity(Interval interval) {
        return ETERNITY.equals((Object)interval);
    }

    @Nullable
    public static Interval findOverlappingInterval(Interval searchInterval, Interval[] sortedIntervals) {
        for (Interval interval : sortedIntervals) {
            if (interval.overlaps((ReadableInterval)searchInterval)) {
                return interval;
            }
            if (!interval.getStart().isAfter((ReadableInstant)searchInterval.getEnd())) continue;
            return null;
        }
        return null;
    }

    private Intervals() {
    }
}

