/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintFromProtoConverter;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintToProtoConverter;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RegisterApplicationMasterRequestPBImpl
extends RegisterApplicationMasterRequest {
    private YarnServiceProtos.RegisterApplicationMasterRequestProto proto = YarnServiceProtos.RegisterApplicationMasterRequestProto.getDefaultInstance();
    private YarnServiceProtos.RegisterApplicationMasterRequestProto.Builder builder = null;
    private Map<Set<String>, PlacementConstraint> placementConstraints = null;
    boolean viaProto = false;

    public RegisterApplicationMasterRequestPBImpl() {
        this.builder = YarnServiceProtos.RegisterApplicationMasterRequestProto.newBuilder();
    }

    public RegisterApplicationMasterRequestPBImpl(YarnServiceProtos.RegisterApplicationMasterRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.RegisterApplicationMasterRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((RegisterApplicationMasterRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.placementConstraints != null) {
            this.addPlacementConstraintMap();
        }
    }

    private void addPlacementConstraintMap() {
        this.maybeInitBuilder();
        this.builder.clearPlacementConstraints();
        if (this.placementConstraints == null) {
            return;
        }
        ArrayList<YarnProtos.PlacementConstraintMapEntryProto> protoList = new ArrayList<YarnProtos.PlacementConstraintMapEntryProto>();
        for (Map.Entry<Set<String>, PlacementConstraint> entry : this.placementConstraints.entrySet()) {
            protoList.add(YarnProtos.PlacementConstraintMapEntryProto.newBuilder().addAllAllocationTags((Iterable<String>)entry.getKey()).setPlacementConstraint(new PlacementConstraintToProtoConverter(entry.getValue()).convert()).build());
        }
        this.builder.addAllPlacementConstraints(protoList);
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.RegisterApplicationMasterRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public String getHost() {
        YarnServiceProtos.RegisterApplicationMasterRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getHost();
    }

    @Override
    public void setHost(String host) {
        this.maybeInitBuilder();
        if (host == null) {
            this.builder.clearHost();
            return;
        }
        this.builder.setHost(host);
    }

    @Override
    public int getRpcPort() {
        YarnServiceProtos.RegisterApplicationMasterRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getRpcPort();
    }

    @Override
    public void setRpcPort(int port) {
        this.maybeInitBuilder();
        this.builder.setRpcPort(port);
    }

    @Override
    public String getTrackingUrl() {
        YarnServiceProtos.RegisterApplicationMasterRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getTrackingUrl();
    }

    @Override
    public void setTrackingUrl(String url) {
        this.maybeInitBuilder();
        if (url == null) {
            this.builder.clearTrackingUrl();
            return;
        }
        this.builder.setTrackingUrl(url);
    }

    private void initPlacementConstraintMap() {
        if (this.placementConstraints != null) {
            return;
        }
        YarnServiceProtos.RegisterApplicationMasterRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.PlacementConstraintMapEntryProto> pcmList = p.getPlacementConstraintsList();
        this.placementConstraints = new HashMap<Set<String>, PlacementConstraint>();
        for (YarnProtos.PlacementConstraintMapEntryProto e : pcmList) {
            this.placementConstraints.put(new HashSet(e.getAllocationTagsList()), new PlacementConstraintFromProtoConverter(e.getPlacementConstraint()).convert());
        }
    }

    @Override
    public Map<Set<String>, PlacementConstraint> getPlacementConstraints() {
        this.initPlacementConstraintMap();
        return this.placementConstraints;
    }

    @Override
    public void setPlacementConstraints(Map<Set<String>, PlacementConstraint> constraints) {
        this.maybeInitBuilder();
        if (constraints == null) {
            this.builder.clearPlacementConstraints();
        } else {
            this.removeEmptyKeys(constraints);
        }
        this.placementConstraints = constraints;
    }

    private void removeEmptyKeys(Map<Set<String>, PlacementConstraint> constraintMap) {
        Iterator<Set<String>> iter = constraintMap.keySet().iterator();
        while (iter.hasNext()) {
            Set<String> aTags = iter.next();
            if (aTags.size() != 0) continue;
            iter.remove();
        }
    }
}

