/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIngestionSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.NoopTaskAutoScaler;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;

public abstract class SeekableStreamSupervisorSpec
implements SupervisorSpec {
    protected static final String ILLEGAL_INPUT_SOURCE_UPDATE_ERROR_MESSAGE = "Update of the input source stream from [%s] to [%s] is not supported for a running supervisor.%nTo perform the update safely, follow these steps:%n(1) Suspend this supervisor, reset its offsets and then terminate it. %n(2) Create a new supervisor with the new input source stream.%nNote that doing the reset can cause data duplication or loss if any topic used in the old supervisor is included in the new one too.";
    protected final String id;
    protected final TaskStorage taskStorage;
    protected final TaskMaster taskMaster;
    protected final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    protected final SeekableStreamIndexTaskClientFactory indexTaskClientFactory;
    protected final ObjectMapper mapper;
    protected final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final SeekableStreamSupervisorIngestionSpec ingestionSchema;
    @Nullable
    private final Map<String, Object> context;
    protected final ServiceEmitter emitter;
    protected final DruidMonitorSchedulerConfig monitorSchedulerConfig;
    private final boolean suspended;
    protected final SupervisorStateManagerConfig supervisorStateManagerConfig;

    private static SeekableStreamSupervisorIngestionSpec checkIngestionSchema(SeekableStreamSupervisorIngestionSpec ingestionSchema) {
        Preconditions.checkNotNull((Object)ingestionSchema, (Object)"ingestionSchema");
        Preconditions.checkNotNull((Object)ingestionSchema.getDataSchema(), (Object)"dataSchema");
        Preconditions.checkNotNull((Object)ingestionSchema.getIOConfig(), (Object)"ioConfig");
        return ingestionSchema;
    }

    public SeekableStreamSupervisorSpec(@Nullable String id, SeekableStreamSupervisorIngestionSpec ingestionSchema, @Nullable Map<String, Object> context, Boolean suspended, TaskStorage taskStorage, TaskMaster taskMaster, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, SeekableStreamIndexTaskClientFactory indexTaskClientFactory, @Json ObjectMapper mapper, ServiceEmitter emitter, DruidMonitorSchedulerConfig monitorSchedulerConfig, RowIngestionMetersFactory rowIngestionMetersFactory, SupervisorStateManagerConfig supervisorStateManagerConfig) {
        this.ingestionSchema = SeekableStreamSupervisorSpec.checkIngestionSchema(ingestionSchema);
        this.id = (String)Preconditions.checkNotNull((Object)((String)Configs.valueOrDefault((Object)id, (Object)ingestionSchema.getDataSchema().getDataSource())), (Object)"spec id cannot be null!");
        this.context = context;
        this.taskStorage = taskStorage;
        this.taskMaster = taskMaster;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.indexTaskClientFactory = indexTaskClientFactory;
        this.mapper = mapper;
        this.emitter = emitter;
        this.monitorSchedulerConfig = monitorSchedulerConfig;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.suspended = suspended != null ? suspended : false;
        this.supervisorStateManagerConfig = supervisorStateManagerConfig;
    }

    @JsonProperty
    public SeekableStreamSupervisorIngestionSpec getSpec() {
        return this.ingestionSchema;
    }

    @Deprecated
    @JsonProperty
    public DataSchema getDataSchema() {
        return this.ingestionSchema.getDataSchema();
    }

    @JsonProperty
    public SeekableStreamSupervisorTuningConfig getTuningConfig() {
        return this.ingestionSchema.getTuningConfig();
    }

    @JsonProperty
    public SeekableStreamSupervisorIOConfig getIoConfig() {
        return this.ingestionSchema.getIOConfig();
    }

    @Nullable
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public <ContextValueType> ContextValueType getContextValue(String key) {
        return (ContextValueType)(this.context == null ? null : this.context.get(key));
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public DruidMonitorSchedulerConfig getMonitorSchedulerConfig() {
        return this.monitorSchedulerConfig;
    }

    public abstract Supervisor createSupervisor();

    public SupervisorTaskAutoScaler createAutoscaler(Supervisor supervisor) {
        AutoScalerConfig autoScalerConfig = this.ingestionSchema.getIOConfig().getAutoScalerConfig();
        if (autoScalerConfig != null && autoScalerConfig.getEnableTaskAutoScaler() && supervisor instanceof SeekableStreamSupervisor) {
            return autoScalerConfig.createAutoScaler(supervisor, this, this.emitter);
        }
        return new NoopTaskAutoScaler();
    }

    public List<String> getDataSources() {
        return ImmutableList.of((Object)this.getDataSchema().getDataSource());
    }

    public SeekableStreamSupervisorSpec createSuspendedSpec() {
        return this.toggleSuspend(true);
    }

    public SeekableStreamSupervisorSpec createRunningSpec() {
        return this.toggleSuspend(false);
    }

    public SupervisorStateManagerConfig getSupervisorStateManagerConfig() {
        return this.supervisorStateManagerConfig;
    }

    @JsonProperty(value="suspended")
    public boolean isSuspended() {
        return this.suspended;
    }

    public void validateSpecUpdateTo(SupervisorSpec proposedSpec) throws DruidException {
        if (!(proposedSpec instanceof SeekableStreamSupervisorSpec)) {
            throw InvalidInput.exception((String)"Cannot update supervisor spec from type[%s] to type[%s]", (Object[])new Object[]{this.getClass().getSimpleName(), proposedSpec.getClass().getSimpleName()});
        }
        SeekableStreamSupervisorSpec other = (SeekableStreamSupervisorSpec)proposedSpec;
        if (this.getSource() == null || other.getSource() == null) {
            throw InvalidInput.exception((String)"Cannot update supervisor spec since one or both of the specs have not provided an input source stream in the 'ioConfig'.", (Object[])new Object[0]);
        }
        if (!this.getSource().equals(other.getSource())) {
            throw InvalidInput.exception((String)ILLEGAL_INPUT_SOURCE_UPDATE_ERROR_MESSAGE, (Object[])new Object[]{this.getSource(), other.getSource()});
        }
    }

    protected abstract SeekableStreamSupervisorSpec toggleSuspend(boolean var1);
}

