/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionStat;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.joda.time.Interval;

public class DeepStoragePartitionStat
implements PartitionStat {
    public static final String TYPE = "deepstore";
    static final String PROP_SHARD_SPEC = "shardSpec";
    private final Map<String, Object> loadSpec;
    private final Interval interval;
    private final BucketNumberedShardSpec shardSpec;

    @JsonCreator
    public DeepStoragePartitionStat(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="shardSpec") BucketNumberedShardSpec shardSpec, @JsonProperty(value="loadSpec") Map<String, Object> loadSpec) {
        this.interval = interval;
        this.shardSpec = shardSpec;
        this.loadSpec = loadSpec;
    }

    @JsonProperty
    public Map<String, Object> getLoadSpec() {
        return this.loadSpec;
    }

    @Override
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="shardSpec")
    public BucketNumberedShardSpec getSecondaryPartition() {
        return this.shardSpec;
    }

    @Override
    public int getBucketId() {
        return this.shardSpec.getBucketId();
    }

    @Override
    public DeepStoragePartitionLocation toPartitionLocation(String subtaskId, BuildingShardSpec secondaryParition) {
        return new DeepStoragePartitionLocation(subtaskId, this.interval, secondaryParition, this.loadSpec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeepStoragePartitionStat that = (DeepStoragePartitionStat)o;
        return this.loadSpec.equals(that.loadSpec) && this.interval.equals((Object)that.interval) && this.shardSpec.equals(that.shardSpec);
    }

    public int hashCode() {
        return Objects.hash(this.loadSpec, this.interval, this.shardSpec);
    }

    public String toString() {
        return "DeepStoragePartitionStat{loadSpec=" + this.loadSpec + ", interval=" + this.interval + ", shardSpec=" + this.shardSpec + "}";
    }
}

