/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.unstable.oracle;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.ResultSetException;
import org.skife.jdbi.v2.tweak.BaseStatementCustomizer;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.StatementCustomizer;

@Deprecated
public class OracleReturning<ResultType>
extends BaseStatementCustomizer
implements StatementCustomizer {
    private ResultSetMapper<ResultType> mapper;
    private final List<int[]> binds = new ArrayList<int[]>();
    private StatementContext context;
    private List<ResultType> results;
    private Class<?> oraclePS;
    private Method registerReturnParameter;
    private Method getReturnResultSet;
    private Object stmt;

    public OracleReturning(ResultSetMapper<ResultType> mapper) {
        this.mapper = mapper;
        try {
            this.oraclePS = Class.forName("oracle.jdbc.OraclePreparedStatement");
            this.registerReturnParameter = this.oraclePS.getMethod("registerReturnParameter", Integer.TYPE, Integer.TYPE);
            this.getReturnResultSet = this.oraclePS.getMethod("getReturnResultSet", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
        this.context = ctx;
        if (!this.oraclePS.isAssignableFrom(stmt.getClass())) {
            try {
                Method get_delegate = stmt.getClass().getMethod("getDelegate", new Class[0]);
                Object candidate = get_delegate.invoke((Object)stmt, new Object[0]);
                if (!this.oraclePS.isAssignableFrom(candidate.getClass())) {
                    throw new Exception("Obtained delegate, but it still wasn't an OraclePreparedStatement");
                }
                this.stmt = candidate;
            }
            catch (Exception e) {
                throw new IllegalStateException("Statement is not an OraclePreparedStatement, norone which we know how to find it from", e);
            }
        } else {
            this.stmt = stmt;
        }
        for (int[] bind : this.binds) {
            try {
                this.registerReturnParameter.invoke(this.stmt, bind[0], bind[1]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void afterExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
        ResultSet rs;
        try {
            rs = (ResultSet)this.getReturnResultSet.invoke(this.stmt, new Object[0]);
        }
        catch (Exception e) {
            throw new ResultSetException("Unable to retrieve return result set", e, ctx);
        }
        this.results = new ArrayList<ResultType>();
        try {
            int i = 0;
            while (rs.next()) {
                this.results.add(this.mapper.map(i++, rs, this.context));
            }
        }
        catch (SQLException e) {
            throw new ResultSetException("Unable to retrieve results from returned result set", e, ctx);
        }
    }

    public List<ResultType> getReturnedResults() {
        return this.results;
    }

    public OracleReturning<ResultType> registerReturnParam(int position, int oracleType) {
        this.binds.add(new int[]{position, oracleType});
        return this;
    }
}

