/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationCommitMessage
extends PacketImpl {
    private byte journalID;
    private boolean rollback;
    private long txId;

    public ReplicationCommitMessage() {
        super((byte)96);
    }

    public ReplicationCommitMessage(byte journalID, boolean rollback, long txId) {
        this();
        this.journalID = journalID;
        this.rollback = rollback;
        this.txId = txId;
    }

    public int expectedEncodeSize() {
        return 23;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.rollback);
        buffer.writeLong(this.txId);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.rollback = buffer.readBoolean();
        this.txId = buffer.readLong();
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.journalID, this.rollback, this.txId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationCommitMessage)) {
            return false;
        }
        ReplicationCommitMessage other = (ReplicationCommitMessage)((Object)obj);
        return this.journalID == other.journalID && this.rollback == other.rollback && this.txId == other.txId;
    }

    protected String getPacketString() {
        String baseString = super.getPacketString();
        String txOperation = this.rollback ? "rollback" : "commmit";
        return baseString + "[type=" + this.getType() + ", channel=" + this.getChannelID() + ", journalID=" + this.journalID + ", txAction='" + txOperation + "'";
    }
}

