/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.text.ExtendedMessageFormat;
import org.apache.commons.text.FormatFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ExtendedMessageFormatTest {
    private final Map<String, FormatFactory> registry = new HashMap<String, FormatFactory>();

    ExtendedMessageFormatTest() {
    }

    private void checkBuiltInFormat(String pattern, Map<String, ?> registryUnused, Object[] args, Locale locale) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Pattern=[");
        buffer.append(pattern);
        buffer.append("], locale=[");
        buffer.append(locale);
        buffer.append("]");
        MessageFormat mf = this.createMessageFormat(pattern, locale);
        ExtendedMessageFormat emf = null;
        emf = locale == null ? new ExtendedMessageFormat(pattern) : new ExtendedMessageFormat(pattern, locale);
        Assertions.assertEquals((Object)mf.format(args), (Object)emf.format((Object)args), (String)("format " + buffer.toString()));
        Assertions.assertEquals((Object)mf.toPattern(), (Object)emf.toPattern(), (String)("toPattern " + buffer.toString()));
    }

    private void checkBuiltInFormat(String pattern, Map<String, ?> fmtRegistry, Object[] args, Locale[] locales) {
        this.checkBuiltInFormat(pattern, fmtRegistry, args, (Locale)null);
        for (Locale locale : locales) {
            this.checkBuiltInFormat(pattern, fmtRegistry, args, locale);
        }
    }

    private void checkBuiltInFormat(String pattern, Object[] args, Locale[] locales) {
        this.checkBuiltInFormat(pattern, null, args, locales);
    }

    private MessageFormat createMessageFormat(String pattern, Locale locale) {
        MessageFormat result = new MessageFormat(pattern);
        if (locale != null) {
            result.setLocale(locale);
            result.applyPattern(pattern);
        }
        return result;
    }

    @BeforeEach
    public void setUp() {
        this.registry.put("lower", LowerCaseFormat.FACTORY);
        this.registry.put("upper", UpperCaseFormat.FACTORY);
    }

    @Test
    void testBuiltInChoiceFormat() {
        Number[] values = new Number[]{1, Double.valueOf("2.2"), Double.valueOf("1234.5")};
        Locale[] availableLocales = NumberFormat.getAvailableLocales();
        String choicePattern = "{0,choice,1#One|2#Two|3#Many {0,number}}";
        for (Number value : values) {
            this.checkBuiltInFormat(value + ": " + choicePattern, new Object[]{value}, availableLocales);
        }
        choicePattern = "{0,choice,1#''One''|2#\"Two\"|3#''{Many}'' {0,number}}";
        for (Number value : values) {
            this.checkBuiltInFormat(value + ": " + choicePattern, new Object[]{value}, availableLocales);
        }
    }

    @Test
    void testBuiltInDateTimeFormat() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23, 18, 33, 5);
        Object[] args = new Object[]{cal.getTime()};
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        this.checkBuiltInFormat("1: {0,date,short}", args, availableLocales);
        this.checkBuiltInFormat("2: {0,date,medium}", args, availableLocales);
        this.checkBuiltInFormat("3: {0,date,long}", args, availableLocales);
        this.checkBuiltInFormat("4: {0,date,full}", args, availableLocales);
        this.checkBuiltInFormat("5: {0,date,d MMM yy}", args, availableLocales);
        this.checkBuiltInFormat("6: {0,time,short}", args, availableLocales);
        this.checkBuiltInFormat("7: {0,time,medium}", args, availableLocales);
        this.checkBuiltInFormat("8: {0,time,long}", args, availableLocales);
        this.checkBuiltInFormat("9: {0,time,full}", args, availableLocales);
        this.checkBuiltInFormat("10: {0,time,HH:mm}", args, availableLocales);
        this.checkBuiltInFormat("11: {0,date}", args, availableLocales);
        this.checkBuiltInFormat("12: {0,time}", args, availableLocales);
    }

    @Test
    void testBuiltInNumberFormat() {
        Object[] args = new Object[]{Double.valueOf("6543.21")};
        Locale[] availableLocales = NumberFormat.getAvailableLocales();
        this.checkBuiltInFormat("1: {0,number}", args, availableLocales);
        this.checkBuiltInFormat("2: {0,number,integer}", args, availableLocales);
        this.checkBuiltInFormat("3: {0,number,currency}", args, availableLocales);
        this.checkBuiltInFormat("4: {0,number,percent}", args, availableLocales);
        this.checkBuiltInFormat("5: {0,number,00000.000}", args, availableLocales);
    }

    @Test
    void testChoiceQuoteJustBeforeBraceEnd_TEXT_106() {
        String pattern2 = "Choice format element with quote just before brace end ''{0,choice,0#0|0<'1'}''";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Choice format element with quote just before brace end ''{0,choice,0#0|0<'1'}''", this.registry);
        Assertions.assertEquals((Object)"Choice format element with quote just before brace end '0'", (Object)emf.format((Object)new Object[]{0}));
        Assertions.assertEquals((Object)"Choice format element with quote just before brace end '1'", (Object)emf.format((Object)new Object[]{1}));
    }

    @Test
    void testCreatesExtendedMessageFormatTakingString() {
        ExtendedMessageFormat extendedMessageFormat = new ExtendedMessageFormat("Unterminated format element at position ");
        HashMap map = new HashMap();
        ExtendedMessageFormat extendedMessageFormatTwo = new ExtendedMessageFormat("Unterminated format element at position ", map);
        Assertions.assertEquals((Object)"Unterminated format element at position ", (Object)extendedMessageFormatTwo.toPattern());
        Assertions.assertNotEquals((Object)extendedMessageFormat, (Object)extendedMessageFormatTwo);
    }

    @Test
    void testEmbeddedPatternInChoice() {
        String pattern = "Hi {0,lower}, got {1,choice,0#none|1#one|1<{1,number}}, {2,upper}!";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Hi {0,lower}, got {1,choice,0#none|1#one|1<{1,number}}, {2,upper}!", this.registry);
        Assertions.assertEquals((Object)"Hi there, got 3, GREAT!", (Object)emf.format((Object)new Object[]{"there", 3, "great"}));
    }

    @Test
    void testEqualsHashcode() {
        Map<String, FormatFactory> fmtRegistry = Collections.singletonMap("testfmt", LowerCaseFormat.FACTORY);
        Map<String, FormatFactory> otherRegistry = Collections.singletonMap("testfmt", UpperCaseFormat.FACTORY);
        String pattern = "Pattern: {0,testfmt}";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assertions.assertEquals((Object)emf, (Object)emf, (String)"same, equals()");
        Assertions.assertEquals((int)emf.hashCode(), (int)emf.hashCode(), (String)"same, hashCode()");
        Assertions.assertNotEquals(null, (Object)emf, (String)"null, equals");
        ExtendedMessageFormat other = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assertions.assertEquals((Object)emf, (Object)other, (String)"equal, equals()");
        Assertions.assertEquals((int)emf.hashCode(), (int)other.hashCode(), (String)"equal, hashCode()");
        other = new OtherExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assertions.assertNotEquals((Object)emf, (Object)other, (String)"class, equals()");
        Assertions.assertEquals((int)emf.hashCode(), (int)other.hashCode(), (String)"class, hashCode()");
        other = new ExtendedMessageFormat("XPattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assertions.assertNotEquals((Object)emf, (Object)other, (String)"pattern, equals()");
        Assertions.assertNotEquals((int)emf.hashCode(), (int)other.hashCode(), (String)"pattern, hashCode()");
        other = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, otherRegistry);
        Assertions.assertNotEquals((Object)emf, (Object)other, (String)"registry, equals()");
        Assertions.assertNotEquals((int)emf.hashCode(), (int)other.hashCode(), (String)"registry, hashCode()");
        other = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.FRANCE, fmtRegistry);
        Assertions.assertNotEquals((Object)emf, (Object)other, (String)"locale, equals()");
        Assertions.assertEquals((int)emf.hashCode(), (int)other.hashCode(), (String)"locale, hashCode()");
    }

    @Test
    void testEscapedBraces_LANG_948() {
        String pattern = "Message without placeholders '{}'";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Message without placeholders '{}'", this.registry);
        Assertions.assertEquals((Object)"Message without placeholders {}", (Object)emf.format((Object)new Object[]{"DUMMY"}));
        String pattern2 = "Message with placeholder ''{0}''";
        ExtendedMessageFormat emf2 = new ExtendedMessageFormat("Message with placeholder ''{0}''", this.registry);
        Assertions.assertEquals((Object)"Message with placeholder 'DUMMY'", (Object)emf2.format((Object)new Object[]{"DUMMY"}));
    }

    @Test
    void testEscapedQuote_LANG_477() {
        String pattern = "it''s a {0,lower} 'test'!";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("it''s a {0,lower} 'test'!", this.registry);
        Assertions.assertEquals((Object)"it's a dummy test!", (Object)emf.format((Object)new Object[]{"DUMMY"}));
    }

    @Test
    void testExtendedAndBuiltInFormats() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23, 18, 33, 5);
        Object[] args = new Object[]{"John Doe", cal.getTime(), Double.valueOf("12345.67")};
        String builtinsPattern = "DOB: {1,date,short} Salary: {2,number,currency}";
        String extendedPattern = "Name: {0,upper} ";
        String pattern = "Name: {0,upper} DOB: {1,date,short} Salary: {2,number,currency}";
        HashSet<Locale> testLocales = new HashSet<Locale>(Arrays.asList(DateFormat.getAvailableLocales()));
        testLocales.retainAll(Arrays.asList(NumberFormat.getAvailableLocales()));
        testLocales.add(null);
        for (Locale locale : testLocales) {
            MessageFormat builtins = this.createMessageFormat("DOB: {1,date,short} Salary: {2,number,currency}", locale);
            String expectedPattern = "Name: {0,upper} " + builtins.toPattern();
            DateFormat df = null;
            NumberFormat nf = null;
            ExtendedMessageFormat emf = null;
            if (locale == null) {
                df = DateFormat.getDateInstance(3);
                nf = NumberFormat.getCurrencyInstance();
                emf = new ExtendedMessageFormat("Name: {0,upper} DOB: {1,date,short} Salary: {2,number,currency}", this.registry);
            } else {
                df = DateFormat.getDateInstance(3, locale);
                nf = NumberFormat.getCurrencyInstance(locale);
                emf = new ExtendedMessageFormat("Name: {0,upper} DOB: {1,date,short} Salary: {2,number,currency}", locale, this.registry);
            }
            StringBuilder expected = new StringBuilder();
            expected.append("Name: ");
            expected.append(args[0].toString().toUpperCase(Locale.ROOT));
            expected.append(" DOB: ");
            expected.append(df.format(args[1]));
            expected.append(" Salary: ");
            expected.append(nf.format(args[2]));
            Assertions.assertEquals((Object)expectedPattern, (Object)emf.toPattern(), (String)("pattern comparison for locale " + locale));
            Assertions.assertEquals((Object)expected.toString(), (Object)emf.format((Object)args), (String)String.valueOf(locale));
        }
    }

    @Test
    void testExtendedFormats() {
        String pattern = "Lower: {0,lower} Upper: {1,upper}";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Lower: {0,lower} Upper: {1,upper}", this.registry);
        Assertions.assertEquals((Object)"Lower: {0,lower} Upper: {1,upper}", (Object)emf.toPattern(), (String)"TOPATTERN");
        Assertions.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"foo", "bar"}));
        Assertions.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"Foo", "Bar"}));
        Assertions.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"FOO", "BAR"}));
        Assertions.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"FOO", "bar"}));
        Assertions.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"foo", "BAR"}));
    }

    @Test
    void testFailsToCreateExtendedMessageFormatTakingTwoArgumentsThrowsIllegalArgumentExceptionFive() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new ExtendedMessageFormat("j/[_D9{0,\"&'+0o", new HashMap()));
    }

    @Test
    void testFailsToCreateExtendedMessageFormatTakingTwoArgumentsThrowsIllegalArgumentExceptionFour() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new ExtendedMessageFormat("RD,nXhM{}{", new HashMap()));
    }

    @Test
    void testFailsToCreateExtendedMessageFormatTakingTwoArgumentsThrowsIllegalArgumentExceptionOne() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new ExtendedMessageFormat("agdXdkR;T1{9 ^,LzXf?", new HashMap()));
    }

    @Test
    void testFailsToCreateExtendedMessageFormatTakingTwoArgumentsThrowsIllegalArgumentExceptionThree() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new ExtendedMessageFormat("9jLh_D9{ ", new HashMap()));
    }

    @Test
    void testFailsToCreateExtendedMessageFormatTakingTwoArgumentsThrowsIllegalArgumentExceptionTwo() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> new ExtendedMessageFormat("a5XdkR;T1{9 ,LzXf?", new HashMap()));
    }

    @Test
    void testOverriddenBuiltinFormat() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23);
        Object[] args = new Object[]{cal.getTime()};
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        Map<String, FormatFactory> dateRegistry = Collections.singletonMap("date", OverrideShortDateFormatFactory.FACTORY);
        this.checkBuiltInFormat("1: {0,date}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("2: {0,date,medium}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("3: {0,date,long}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("4: {0,date,full}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("5: {0,date,d MMM yy}", dateRegistry, args, availableLocales);
        for (int i = -1; i < availableLocales.length; ++i) {
            Locale locale = i < 0 ? null : availableLocales[i];
            MessageFormat dateDefault = this.createMessageFormat("{0,date}", locale);
            String pattern = "{0,date,short}";
            ExtendedMessageFormat dateShort = new ExtendedMessageFormat("{0,date,short}", locale, dateRegistry);
            Assertions.assertEquals((Object)dateDefault.format(args), (Object)dateShort.format((Object)args), (String)"overridden date,short format");
            Assertions.assertEquals((Object)"{0,date,short}", (Object)dateShort.toPattern(), (String)"overridden date,short pattern");
        }
    }

    @Test
    void testSetFormatByArgumentIndexIsUnsupported() {
        Assertions.assertThrowsExactly(UnsupportedOperationException.class, () -> new ExtendedMessageFormat("").setFormatByArgumentIndex(0, (Format)new LowerCaseFormat()));
    }

    @Test
    void testSetFormatIsUnsupported() {
        Assertions.assertThrowsExactly(UnsupportedOperationException.class, () -> new ExtendedMessageFormat("").setFormat(0, (Format)new LowerCaseFormat()));
    }

    @Test
    void testSetFormatsByArgumentIndex() {
        Assertions.assertThrowsExactly(UnsupportedOperationException.class, () -> new ExtendedMessageFormat("").setFormatsByArgumentIndex(new Format[]{new LowerCaseFormat(), new UpperCaseFormat()}));
    }

    @Test
    void testSetFormatsIsUnsupported() {
        Assertions.assertThrowsExactly(UnsupportedOperationException.class, () -> new ExtendedMessageFormat("").setFormats(new Format[]{new LowerCaseFormat(), new UpperCaseFormat()}));
    }

    private static final class LowerCaseFormat
    extends Format {
        static final Format INSTANCE = new LowerCaseFormat();
        static final FormatFactory FACTORY = (n, a, l) -> INSTANCE;
        private static final long serialVersionUID = 1L;

        private LowerCaseFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((String)obj).toLowerCase(Locale.ROOT));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class UpperCaseFormat
    extends Format {
        static final Format INSTANCE = new UpperCaseFormat();
        static final FormatFactory FACTORY = (n, a, l) -> INSTANCE;
        private static final long serialVersionUID = 1L;

        private UpperCaseFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((String)obj).toUpperCase(Locale.ROOT));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class OtherExtendedMessageFormat
    extends ExtendedMessageFormat {
        private static final long serialVersionUID = 1L;

        OtherExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
            super(pattern, locale, registry);
        }
    }

    private static final class OverrideShortDateFormatFactory {
        static final FormatFactory FACTORY = (n, a, l) -> !"short".equals(a) ? null : (l == null ? DateFormat.getDateInstance(2) : DateFormat.getDateInstance(2, l));

        private OverrideShortDateFormatFactory() {
        }
    }
}

