/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.xml.DataChannelHandler;
import org.apache.cayenne.configuration.xml.DataMapLoaderListener;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.compatibility.CompatibilityUpgradeService;
import org.apache.cayenne.project.compatibility.DocumentProvider;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.UpgradeService;
import org.apache.cayenne.project.upgrade.UpgradeType;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CompatibilityDataChannelDescriptorLoader
extends XMLDataChannelDescriptorLoader {
    private static final Logger logger = LoggerFactory.getLogger(XMLDataChannelDescriptorLoader.class);
    @Inject
    Provider<UpgradeService> upgradeServiceProvider;
    @Inject
    DocumentProvider documentProvider;

    public ConfigurationTree<DataChannelDescriptor> load(Resource configurationResource) throws ConfigurationException {
        if (configurationResource == null) {
            throw new NullPointerException("Null configurationResource");
        }
        if (!(this.upgradeServiceProvider.get() instanceof CompatibilityUpgradeService)) {
            throw new ConfigurationException("CompatibilityUpgradeService expected", new Object[0]);
        }
        CompatibilityUpgradeService upgradeService = (CompatibilityUpgradeService)((Object)this.upgradeServiceProvider.get());
        UpgradeMetaData metaData = upgradeService.getUpgradeType(configurationResource);
        if (metaData.getUpgradeType() == UpgradeType.UPGRADE_NOT_NEEDED) {
            return super.load(configurationResource);
        }
        if (metaData.getUpgradeType() == UpgradeType.DOWNGRADE_NEEDED) {
            throw new ConfigurationException("Unable to load configuration from %s: It was created using a newer version of the Modeler", new Object[]{configurationResource.getURL()});
        }
        if (metaData.getUpgradeType() == UpgradeType.INTERMEDIATE_UPGRADE_NEEDED) {
            throw new ConfigurationException("Unable to load configuration from %s: Open the project in the older Modeler to do an intermediate upgrade.", new Object[]{configurationResource.getURL()});
        }
        URL configurationURL = configurationResource.getURL();
        upgradeService.upgradeProject(configurationResource);
        Document projectDocument = this.documentProvider.getDocument(configurationURL);
        if (projectDocument == null) {
            throw new ConfigurationException("Unable to upgrade " + configurationURL, new Object[0]);
        }
        logger.info("Loading XML configuration resource from " + configurationURL);
        final DataChannelDescriptor descriptor = new DataChannelDescriptor();
        descriptor.setConfigurationSource(configurationResource);
        descriptor.setName(this.nameMapper.configurationNodeName(DataChannelDescriptor.class, configurationResource));
        try {
            DOMSource source = new DOMSource(projectDocument);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.newTransformer().transform(source, new StreamResult(baos));
            InputSource isource = new InputSource(source.getSystemId());
            isource.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
            XMLReader parser = Util.createXmlReader();
            LoaderContext loaderContext = new LoaderContext(parser, this.handlerFactory);
            loaderContext.addDataMapListener(new DataMapLoaderListener(){

                public void onDataMapLoaded(DataMap dataMap) {
                    descriptor.getDataMaps().add(dataMap);
                }
            });
            DataChannelHandler rootHandler = new DataChannelHandler((XMLDataChannelDescriptorLoader)this, descriptor, loaderContext);
            parser.setContentHandler((ContentHandler)rootHandler);
            parser.setErrorHandler((ErrorHandler)rootHandler);
            parser.parse(isource);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration from %s", (Throwable)e, new Object[]{configurationURL});
        }
        upgradeService.upgradeModel(configurationResource, descriptor);
        return new ConfigurationTree((ConfigurationNode)descriptor, null);
    }
}

