/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.pref.TemplateCreatorView;
import org.apache.cayenne.modeler.dialog.pref.TemplatePreferences;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;

public class TemplateCreator
extends CayenneController {
    protected TemplateCreatorView view;
    protected boolean canceled;
    protected Set<String> existingNames;
    protected CayennePreferenceEditor editor;
    protected Preferences preferences;
    private static final String ERROR = "Error";

    public TemplateCreator(TemplatePreferences parent) {
        super(parent);
        JDialog parentDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, parent.getView());
        this.view = new TemplateCreatorView(parentDialog);
        this.existingNames = new HashSet<String>();
        PreferenceEditor editor = parent.getEditor();
        if (editor instanceof CayennePreferenceEditor) {
            this.editor = (CayennePreferenceEditor)editor;
        }
        this.preferences = parent.getTemplatePreferences();
        for (FSPath path : parent.getTemplateEntries()) {
            this.existingNames.add(path.getKey());
        }
        this.initBindings();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    FSPath getLastTemplateDirectory() {
        FSPath path = new FSPath(this.application.getPreferencesNode(CodeTemplateManager.class, "lastTemplate"));
        if (path.getPath() == null) {
            path.setPath(this.getLastDirectory().getPath());
        }
        return path;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getOkButton(), "okAction()");
        FSPath path = this.getLastTemplateDirectory();
        this.view.getTemplateChooser().setCurrentDirectory(path.getExistingDirectory(false));
        this.view.getTemplateChooser().addPropertyChangeListener("currentDirectory", evt -> {
            File directory = this.view.getTemplateChooser().getCurrentDirectory();
            path.setDirectory(directory);
        });
    }

    public void okAction() {
        String templateName = this.view.getTemplateName().getText();
        if (Util.isEmptyString(templateName)) {
            JOptionPane.showMessageDialog(this.view, "Enter Template Name", ERROR, 2);
        } else if (this.existingNames.contains(templateName)) {
            JOptionPane.showMessageDialog(this.view, "'" + templateName + "' is already taken, enter a different name", ERROR, 2);
        } else if (this.view.getTemplateChooser().getFile() == null) {
            JOptionPane.showMessageDialog(this.view, "Must select an existing template file", ERROR, 2);
        } else {
            this.canceled = false;
            this.view.dispose();
        }
    }

    public void cancelAction() {
        this.canceled = true;
        this.view.dispose();
    }

    public FSPath startupAction() {
        this.canceled = true;
        this.view.setModal(true);
        this.view.pack();
        this.view.setResizable(false);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
        return this.createTemplate();
    }

    protected FSPath createTemplate() {
        if (this.canceled) {
            return null;
        }
        String name = this.view.getTemplateName().getText();
        File file = this.view.getTemplateChooser().getFile();
        String path = file != null ? file.getAbsolutePath() : null;
        FSPath fsPath = this.application.getCodeTemplateManager().addTemplate(path, name);
        this.editor.getAddedNode().add(fsPath.getCurrentPreference());
        return fsPath;
    }
}

