/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.xml;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.map.DataMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CgenConfigHandler
extends NamespaceAwareNestedTagHandler {
    public static final String CONFIG_TAG = "cgen";
    private static final String OUTPUT_DIRECTORY_TAG = "destDir";
    private static final String GENERATION_MODE_TAG = "mode";
    private static final String SUBCLASS_TEMPLATE_TAG = "template";
    private static final String SUPERCLASS_TEMPLATE_TAG = "superTemplate";
    private static final String EMBEDDABLE_TEMPLATE_TAG = "embeddableTemplate";
    private static final String EMBEDDABLE_SUPER_TEMPLATE_TAG = "embeddableSuperTemplate";
    private static final String QUERY_TEMPLATE_TAG = "queryTemplate";
    private static final String QUERY_SUPER_TEMPLATE_TAG = "querySuperTemplate";
    private static final String OUTPUT_PATTERN_TAG = "outputPattern";
    private static final String MAKE_PAIRS_TAG = "makePairs";
    private static final String USE_PKG_PATH_TAG = "usePkgPath";
    private static final String OVERWRITE_SUBCLASSES_TAG = "overwrite";
    private static final String CREATE_PROPERTY_NAMES_TAG = "createPropertyNames";
    private static final String EXCLUDE_ENTITIES_TAG = "excludeEntities";
    private static final String EXCLUDE_EMBEDDABLES_TAG = "excludeEmbeddables";
    private static final String CREATE_PK_PROPERTIES = "createPKProperties";
    private static final String CLIENT_TAG = "client";
    private static final String SUPER_PKG_TAG = "superPkg";
    public static final String TRUE = "true";
    private DataChannelMetaData metaData;
    private CgenConfiguration configuration;

    CgenConfigHandler(NamespaceAwareNestedTagHandler parentHandler, DataChannelMetaData metaData) {
        super(parentHandler);
        this.metaData = metaData;
        this.targetNamespace = "http://cayenne.apache.org/schema/10/cgen";
        this.configuration = new CgenConfiguration(false);
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "cgen": {
                this.createConfig();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processCharData(String localName, String data) {
        switch (localName) {
            case "destDir": {
                this.createOutputDir(data);
                break;
            }
            case "mode": {
                this.createGenerationMode(data);
                break;
            }
            case "excludeEntities": {
                this.createExcludeEntities(data);
                break;
            }
            case "excludeEmbeddables": {
                this.createExcludeEmbeddables(data);
                break;
            }
            case "template": {
                this.createSubclassTemplate(data);
                break;
            }
            case "superTemplate": {
                this.createSuperclassTemplate(data);
                break;
            }
            case "embeddableTemplate": {
                this.createEmbeddableTemplate(data);
                break;
            }
            case "embeddableSuperTemplate": {
                this.createEmbeddableSuperTemplate(data);
            }
            case "queryTemplate": {
                this.createQueryTemplate(data);
                break;
            }
            case "querySuperTemplate": {
                this.createQuerySuperTemplate(data);
                break;
            }
            case "outputPattern": {
                this.createOutputPattern(data);
                break;
            }
            case "makePairs": {
                this.createMakePairs(data);
                break;
            }
            case "usePkgPath": {
                this.createUsePkgPath(data);
                break;
            }
            case "overwrite": {
                this.createOverwriteSubclasses(data);
                break;
            }
            case "createPropertyNames": {
                this.createPropertyNamesTag(data);
                break;
            }
            case "createPKProperties": {
                this.createPkPropertiesTag(data);
                break;
            }
            case "client": {
                this.createClient(data);
                break;
            }
            case "superPkg": {
                this.createSuperPkg(data);
            }
        }
    }

    private void createOutputDir(String path) {
        if (path.trim().length() == 0) {
            return;
        }
        this.configuration.setRelPath(Paths.get(path, new String[0]));
    }

    private void createGenerationMode(String mode) {
        if (mode.trim().length() == 0) {
            return;
        }
        this.configuration.setArtifactsGenerationMode(mode);
    }

    private void createExcludeEntities(String entities) {
        if (entities.trim().length() == 0) {
            return;
        }
        this.configuration.loadEntities(entities);
    }

    private void createExcludeEmbeddables(String embeddables) {
        if (embeddables.trim().length() == 0) {
            return;
        }
        this.configuration.loadEmbeddables(embeddables);
    }

    private void createSubclassTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        this.configuration.setTemplate(template);
    }

    private void createSuperclassTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        this.configuration.setSuperTemplate(template);
    }

    private void createEmbeddableTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        this.configuration.setEmbeddableTemplate(template);
    }

    private void createEmbeddableSuperTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        this.configuration.setEmbeddableSuperTemplate(template);
    }

    private void createQueryTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        this.configuration.setQueryTemplate(template);
    }

    private void createQuerySuperTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        this.configuration.setQuerySuperTemplate(template);
    }

    private void createOutputPattern(String pattern) {
        if (pattern.trim().length() == 0) {
            return;
        }
        this.configuration.setOutputPattern(pattern);
    }

    private void createMakePairs(String makePairs) {
        if (makePairs.trim().length() == 0) {
            return;
        }
        this.configuration.setMakePairs(makePairs.equals(TRUE));
    }

    private void createUsePkgPath(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setUsePkgPath(data.equals(TRUE));
    }

    private void createOverwriteSubclasses(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setOverwrite(data.equals(TRUE));
    }

    private void createPropertyNamesTag(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setCreatePropertyNames(data.equals(TRUE));
    }

    private void createPkPropertiesTag(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setCreatePKProperties(data.equals(TRUE));
    }

    private void createClient(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setClient(data.equals(TRUE));
    }

    private void createSuperPkg(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setSuperPkg(data);
    }

    private void createConfig() {
        this.loaderContext.addDataMapListener(dataMap -> {
            this.configuration.setDataMap(dataMap);
            this.configuration.setRootPath(this.buildRootPath(dataMap));
            this.configuration.resolveExcludeEntities();
            this.configuration.resolveExcludeEmbeddables();
            this.metaData.add(dataMap, this.configuration);
        });
    }

    private Path buildRootPath(DataMap dataMap) {
        Path resourcePath;
        URL url = dataMap.getConfigurationSource().getURL();
        try {
            resourcePath = Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new CayenneRuntimeException("Unable to read cgen path", (Throwable)e, new Object[0]);
        }
        if (Files.isRegularFile(resourcePath, new LinkOption[0])) {
            resourcePath = resourcePath.getParent();
        }
        return resourcePath;
    }
}

