/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.xml.DataSourceChildrenHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.conn.DataSourceInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

final class DataNodeChildrenHandler
extends NamespaceAwareNestedTagHandler {
    static final String DATA_SOURCE_TAG = "data-source";
    static final String MAP_REF_TAG = "map-ref";
    private XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader;
    private DataNodeDescriptor nodeDescriptor;
    private DataSourceInfo dataSourceDescriptor;

    DataNodeChildrenHandler(XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader, NamespaceAwareNestedTagHandler parentHandler, DataNodeDescriptor nodeDescriptor) {
        super(parentHandler);
        this.xmlDataChannelDescriptorLoader = xmlDataChannelDescriptorLoader;
        this.nodeDescriptor = nodeDescriptor;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) {
        switch (localName) {
            case "map-ref": {
                this.nodeDescriptor.getDataMapNames().add(attributes.getValue("name"));
                return true;
            }
            case "data-source": {
                this.nodeDescriptor.setDataSourceDescriptor(this.dataSourceDescriptor);
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
        if (DATA_SOURCE_TAG.equals(localName)) {
            this.dataSourceDescriptor = new DataSourceInfo();
            return new DataSourceChildrenHandler(this.xmlDataChannelDescriptorLoader, this, this.dataSourceDescriptor);
        }
        return super.createChildTagHandler(namespaceURI, localName, name, attributes);
    }
}

