/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.cassandra.spark.utils.Preconditions;
import org.jetbrains.annotations.Nullable;

public class AvroSchemas {
    private static final LogicalType ARRAY_MAP_LOGICAL_TYPE = new LogicalType("array_map");
    private static final LogicalType ARRAY_SET_LOGICAL_TYPE = new LogicalType("array_set");
    private static final LogicalType UDT_LOGICAL_TYPE = new LogicalType("record_udt");
    private static final LogicalType INET_LOGICAL_TYPE = new LogicalType("inet");
    private static final LogicalType VARIABLE_INTEGER_LOGICAL_TYPE = new LogicalType("varint");

    private AvroSchemas() {
    }

    public static void registerLogicalTypes() {
        LogicalTypes.register((String)"array_map", schema -> ARRAY_MAP_LOGICAL_TYPE);
        LogicalTypes.register((String)"array_set", schema -> ARRAY_SET_LOGICAL_TYPE);
        LogicalTypes.register((String)"record_udt", schema -> UDT_LOGICAL_TYPE);
        LogicalTypes.register((String)"inet", schema -> INET_LOGICAL_TYPE);
        LogicalTypes.register((String)"varint", schema -> VARIABLE_INTEGER_LOGICAL_TYPE);
    }

    public static boolean isArrayBasedMap(Schema schema) {
        if (schema.getType() == Schema.Type.ARRAY) {
            LogicalType logicalType = schema.getLogicalType();
            return logicalType != null && logicalType.getName().equals("array_map");
        }
        return false;
    }

    public static void flagArrayAsMap(Schema schema) {
        Preconditions.checkArgument((schema.getType() == Schema.Type.ARRAY ? 1 : 0) != 0);
        new LogicalType("array_map").addToSchema(schema);
    }

    public static void flagAsUdt(Schema schema) {
        Preconditions.checkArgument((schema.getType() == Schema.Type.RECORD ? 1 : 0) != 0);
        new LogicalType("record_udt").addToSchema(schema);
    }

    public static boolean isRecordBasedUdt(Schema schema) {
        if (schema.getType() == Schema.Type.RECORD) {
            LogicalType logicalType = schema.getLogicalType();
            return logicalType != null && logicalType.getName().equals("record_udt");
        }
        return false;
    }

    public static void setPrimaryKeys(Schema schema, List<String> primaryKeys) {
        schema.addProp("primary_keys", primaryKeys);
    }

    public static List<String> primaryKeys(Schema schema) {
        return (List)schema.getObjectProp("primary_keys");
    }

    public static void setPartitionKeys(Schema schema, List<String> partitionKeys) {
        schema.addProp("partition_keys", partitionKeys);
    }

    public static List<String> partitionKeys(Schema schema) {
        return (List)schema.getObjectProp("partition_keys");
    }

    public static void setClusteringKeys(Schema schema, List<String> clusteringKeys) {
        schema.addProp("clustering_keys", clusteringKeys);
    }

    public static List<String> clusteringKeys(Schema schema) {
        return (List)schema.getObjectProp("clustering_keys");
    }

    public static void setStaticColumns(Schema schema, List<String> staticColumns) {
        schema.addProp("static_columns", staticColumns);
    }

    public static List<String> staticColumns(Schema schema) {
        return (List)schema.getObjectProp("static_columns");
    }

    public static void flagCqlType(Schema schema, String cqlType) {
        schema.addProp("cqlType", cqlType);
    }

    @Nullable
    public static String cqlType(Schema schema) {
        return schema.getProp("cqlType");
    }

    public static boolean isFrozen(Schema schema) {
        String flag = schema.getProp("isFrozen");
        return Boolean.parseBoolean(flag);
    }

    public static void flagFrozen(Schema schema) {
        schema.addProp("isFrozen", "true");
    }

    public static void flagReversed(Schema schema) {
        schema.addProp("isReversed", "true");
    }

    public static boolean isArrayBasedSet(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        return logicalType != null && logicalType.getName().equals("array_set");
    }

    public static void flagArrayAsSet(Schema schema) {
        new LogicalType("array_set").addToSchema(schema);
    }

    public static Schema unwrapNullable(Schema schema) {
        if (schema.getType() != Schema.Type.UNION || schema.getTypes().size() != 2) {
            return schema;
        }
        boolean hasNull = false;
        Schema actual = null;
        for (Schema s : schema.getTypes()) {
            if (s.getType() == Schema.Type.NULL) {
                hasNull = true;
                continue;
            }
            actual = s;
        }
        return hasNull && actual != null ? actual : schema;
    }
}

