/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.complex;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ValueComparators;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.SetSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.complex.CqlList;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CqlSet
extends CqlList
implements CqlField.CqlSet {
    public CqlSet(CqlField.CqlType type) {
        super(type);
    }

    @Override
    public AbstractType<?> dataType(boolean isMultiCell) {
        return SetType.getInstance(((CqlType)this.type()).dataType(), (boolean)isMultiCell);
    }

    @Override
    public CqlField.CqlType.InternalType internalType() {
        return CqlField.CqlType.InternalType.Set;
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return SetSerializer.getInstance(((CqlType)this.type()).serializer(), (ValueComparators)((CqlType)this.type()).dataType().comparatorSet);
    }

    @Override
    public String name() {
        return "set";
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return new HashSet((List)super.randomValue(minCollectionSize));
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setSet(position, (Set)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.set((DataType)((CqlType)this.type()).driverDataType(isFrozen));
    }

    @Override
    public Object convertForCqlWriter(Object value, CassandraVersion version, boolean isCollectionElement) {
        return ((Set)value).stream().map(element -> this.type().convertForCqlWriter(element, version, true)).collect(Collectors.toSet());
    }

    @Override
    public void addCell(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp, int ttl, int now, Object value) {
        for (Object o : (Set)value) {
            if (ttl != 0) {
                rowBuilder.addCell((Cell)BufferCell.expiring((ColumnMetadata)cd, (long)timestamp, (int)ttl, (int)now, (ByteBuffer)ByteBufferUtil.EMPTY_BYTE_BUFFER, (CellPath)CellPath.create((ByteBuffer)this.type().serialize(o))));
                continue;
            }
            rowBuilder.addCell((Cell)BufferCell.live((ColumnMetadata)cd, (long)timestamp, (ByteBuffer)ByteBufferUtil.EMPTY_BYTE_BUFFER, (CellPath)CellPath.create((ByteBuffer)this.type().serialize(o))));
        }
    }
}

