/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.cdc.CdcLogger;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.spark.data.CqlField;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CdcLogMode implements CdcLogger
{
    MINIMAL{

        @Override
        public void info(Logger logger, String message, CdcEvent event, String topic) {
            logger.info("{}. kind={} keyspace={} table={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, topic});
        }

        @Override
        public void warn(Logger logger, String message, CdcEvent event, String topic, Throwable cause) {
            logger.warn("{}. kind={} keyspace={} table={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, topic, cause});
        }

        @Override
        public void error(Logger logger, String message, CdcEvent event, String topic, Throwable cause) {
            logger.error("{}. kind={} keyspace={} table={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, topic, cause});
        }
    }
    ,
    PARTITION_KEYS{

        @Override
        public void info(Logger logger, String message, CdcEvent event, String topic) {
            logger.info("{}. kind={} keyspace={} table={} partitionKeys={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, CdcLogMode.columnsToString(event.getPartitionKeys()), topic});
        }

        @Override
        public void warn(Logger logger, String message, CdcEvent event, String topic, Throwable cause) {
            logger.warn("{}. kind={} keyspace={} table={} partitionKeys={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, CdcLogMode.columnsToString(event.getPartitionKeys()), topic, cause});
        }

        @Override
        public void error(Logger logger, String message, CdcEvent event, String topic, Throwable cause) {
            logger.error("{}. kind={} keyspace={} table={} partitionKeys={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, CdcLogMode.columnsToString(event.getPartitionKeys()), topic, cause});
        }
    }
    ,
    FULL{

        @Override
        public void info(Logger logger, String message, CdcEvent event, String topic) {
            logger.info("{}. kind={} keyspace={} table={} partitionKeys={} clusteringKeys={} valueColumns={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, CdcLogMode.columnsToString(event.getPartitionKeys()), CdcLogMode.columnsToString(event.getClusteringKeys()), CdcLogMode.columnsToString(event.getValueColumns()), topic});
        }

        @Override
        public void warn(Logger logger, String message, CdcEvent event, String topic, Throwable cause) {
            logger.warn("{}. kind={} keyspace={} table={} partitionKeys={} clusteringKeys={} valueColumns={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, CdcLogMode.columnsToString(event.getPartitionKeys()), CdcLogMode.columnsToString(event.getClusteringKeys()), CdcLogMode.columnsToString(event.getValueColumns()), topic, cause});
        }

        @Override
        public void error(Logger logger, String message, CdcEvent event, String topic, Throwable cause) {
            logger.error("{}. kind={} keyspace={} table={} partitionKeys={} clusteringKeys={} valueColumns={} topic={}", new Object[]{message, event.getKind(), event.keyspace, event.table, CdcLogMode.columnsToString(event.getPartitionKeys()), CdcLogMode.columnsToString(event.getClusteringKeys()), CdcLogMode.columnsToString(event.getValueColumns()), topic, cause});
        }
    };

    private static final Logger LOGGER;
    private static Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup;

    public static synchronized void init(Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        if (CdcLogMode.typeLookup != null) {
            LOGGER.warn("CdcLogMode is already initialized!");
            return;
        }
        CdcLogMode.typeLookup = typeLookup;
    }

    public static CdcLogMode fromOption(String name) {
        try {
            return CdcLogMode.valueOf(name.toUpperCase());
        }
        catch (Exception exception) {
            LOGGER.warn("Unrecognized mode: {} from input. Using the default MINIMAL", (Object)name, (Object)exception);
            return MINIMAL;
        }
    }

    private static String columnToString(Value fieldValue) {
        try {
            CqlField.CqlType type = typeLookup.apply(KeyspaceTypeKey.of((String)fieldValue.keyspace, (String)fieldValue.columnType));
            Object javaValue = type.deserializeToJavaType(fieldValue.getValue());
            return String.format("[%s : %s]", fieldValue.columnName, javaValue);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to deserialize column value. columnName={}", (Object)fieldValue.columnName, (Object)t);
            return String.format("[%s : unknown]", fieldValue.columnName);
        }
    }

    private static String columnsToString(@Nullable List<Value> columns) {
        return columns == null ? "null" : columns.stream().map(CdcLogMode::columnToString).collect(Collectors.joining(", "));
    }

    static {
        LOGGER = LoggerFactory.getLogger(CdcLogMode.class);
        typeLookup = null;
    }
}

