/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.XXHash32Digest;
import org.apache.cassandra.spark.utils.DigestAlgorithm;

public class XXHash32DigestAlgorithm
implements DigestAlgorithm {
    private static final int KIB_512 = 524288;
    private static final int SEED = 0;

    @Override
    public Digest calculateFileDigest(Path path) throws IOException {
        XXHashFactory factory = XXHashFactory.safeInstance();
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            XXHash32Digest xXHash32Digest;
            block13: {
                StreamingXXHash32 hasher = factory.newStreamingHash32(0);
                try {
                    int len;
                    byte[] buffer = new byte[524288];
                    while ((len = inputStream.read(buffer)) != -1) {
                        hasher.update(buffer, 0, len);
                    }
                    xXHash32Digest = new XXHash32Digest(Integer.toHexString(hasher.getValue()), 0);
                    if (hasher == null) break block13;
                }
                catch (Throwable throwable) {
                    if (hasher != null) {
                        try {
                            hasher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hasher.close();
            }
            return xXHash32Digest;
        }
    }
}

