/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.spark.config.SchemaFeature;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.AbstractSparkRowIterator;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SparkRowIterator
extends AbstractSparkRowIterator<GenericInternalRow>
implements PartitionReader<InternalRow> {
    @VisibleForTesting
    public SparkRowIterator(int partitionId, @NotNull DataLayer dataLayer) {
        this(partitionId, dataLayer, null, new ArrayList<PartitionKeyFilter>());
    }

    public SparkRowIterator(int partitionId, @NotNull DataLayer dataLayer, @Nullable StructType requiredSchema, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        super(partitionId, dataLayer, requiredSchema, partitionKeyFilters, builder -> SparkRowIterator.decorate(requiredSchema, (RowBuilder<GenericInternalRow>)builder, dataLayer.requestedFeatures()));
    }

    protected static RowBuilder<GenericInternalRow> decorate(@Nullable StructType requiredSchema, RowBuilder<GenericInternalRow> builder, List<SchemaFeature> features) {
        HashSet<String> fieldNames = requiredSchema == null ? null : new HashSet<String>(Arrays.asList(requiredSchema.fieldNames()));
        for (SchemaFeature feature : features) {
            if (fieldNames != null && !fieldNames.contains(feature.fieldName())) continue;
            builder = feature.decorate(builder);
        }
        return builder;
    }

    @Override
    public GenericInternalRow rowBuilder(Object[] valueArray) {
        return new GenericInternalRow(valueArray);
    }
}

