/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.logging.JULLogDelegateFactory;
import o.a.c.sidecar.client.shaded.io.vertx.core.logging.Logger;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.logging.LogDelegate;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.logging.LogDelegateFactory;

public class LoggerFactory {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "vertx.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    public static synchronized void initialise() {
        String className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception ignore) {
            className = null;
        }
        if (className != null && LoggerFactory.configureWith(className, false, loader)) {
            return;
        }
        if (loader.getResource("vertx-default-jul-logging.properties") == null && (LoggerFactory.configureWith("SLF4J", true, loader) || LoggerFactory.configureWith("Log4j2", true, loader))) {
            return;
        }
        delegateFactory = new JULLogDelegateFactory();
    }

    private static boolean configureWith(String name, boolean shortName, ClassLoader loader) {
        try {
            Class<?> clazz = Class.forName(shortName ? "o.a.c.sidecar.client.shaded.io.vertx.core.logging." + name + "LogDelegateFactory" : name, true, loader);
            LogDelegateFactory factory = (LogDelegateFactory)clazz.newInstance();
            if (!factory.isAvailable()) {
                return false;
            }
            delegateFactory = factory;
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    @Deprecated
    public static Logger getLogger(Class<?> clazz) {
        String name = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LoggerFactory.getLogger(name);
    }

    @Deprecated
    public static Logger getLogger(String name) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger = (Logger)loggers.get(name);
        if (logger == null && (oldLogger = loggers.putIfAbsent(name, logger = new Logger(delegate = delegateFactory.createDelegate(name)))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    @Deprecated
    public static void removeLogger(String name) {
        loggers.remove(name);
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
        LogDelegate log = delegateFactory.createDelegate(LoggerFactory.class.getName());
        log.debug("Using " + delegateFactory.getClass().getName());
    }
}

