/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.BloomFilter;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.bridge.SSTableWriter;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.bridge.Tokenizer;
import org.apache.cassandra.spark.data.BasicSupplier;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.RowData;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.PruneColumnFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.util.CompressionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CassandraBridge {
    public static final String IMPLEMENTATION_FQCN = "org.apache.cassandra.bridge.CassandraBridgeImplementation";

    public abstract CassandraTypes cassandraTypes();

    public abstract AbstractMap.SimpleEntry<ByteBuffer, BigInteger> getPartitionKey(@NotNull CqlTable var1, @NotNull Partitioner var2, @NotNull List<String> var3);

    public abstract StreamScanner<RowData> getCompactionScanner(@NotNull CqlTable var1, @NotNull Partitioner var2, @NotNull SSTablesSupplier var3, @Nullable SparkRangeFilter var4, @NotNull Collection<PartitionKeyFilter> var5, @Nullable PruneColumnFilter var6, @NotNull TimeProvider var7, boolean var8, boolean var9, @NotNull Stats var10);

    public abstract StreamScanner<IndexEntry> getPartitionSizeIterator(@NotNull CqlTable var1, @NotNull Partitioner var2, @NotNull SSTablesSupplier var3, @Nullable SparkRangeFilter var4, @NotNull TimeProvider var5, @NotNull Stats var6, @NotNull ExecutorService var7);

    public abstract CassandraVersion getVersion();

    public abstract BigInteger hash(Partitioner var1, ByteBuffer var2);

    public abstract UUID getTimeUUID();

    @VisibleForTesting
    public CqlTable buildSchema(String createStatement, String keyspace) {
        return this.buildSchema(createStatement, keyspace, new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3)));
    }

    @VisibleForTesting
    public CqlTable buildSchema(String createStatement, String keyspace, ReplicationFactor replicationFactor) {
        return this.buildSchema(createStatement, keyspace, replicationFactor, Partitioner.Murmur3Partitioner);
    }

    @VisibleForTesting
    public CqlTable buildSchema(String createStatement, String keyspace, ReplicationFactor replicationFactor, Partitioner partitioner) {
        return this.buildSchema(createStatement, keyspace, replicationFactor, partitioner, Collections.emptySet());
    }

    @VisibleForTesting
    public CqlTable buildSchema(String createStatement, String keyspace, ReplicationFactor replicationFactor, Partitioner partitioner, Set<String> udts) {
        return this.buildSchema(createStatement, keyspace, replicationFactor, partitioner, udts, null, 0, false);
    }

    public abstract CqlTable buildSchema(String var1, String var2, ReplicationFactor var3, Partitioner var4, Set<String> var5, @Nullable UUID var6, int var7, boolean var8);

    public String maybeQuoteIdentifier(String identifier) {
        return this.cassandraTypes().maybeQuoteIdentifier(identifier);
    }

    public CqlField.CqlType readType(CqlField.CqlType.InternalType type, Input input) {
        return this.cassandraTypes().readType(type, input);
    }

    public List<CqlField.NativeType> allTypes() {
        return this.cassandraTypes().allTypes();
    }

    public Map<String, ? extends CqlField.NativeType> nativeTypeNames() {
        return this.cassandraTypes().nativeTypeNames();
    }

    public CqlField.NativeType nativeType(String name) {
        return this.nativeTypeNames().get(name.toLowerCase());
    }

    public List<CqlField.NativeType> supportedTypes() {
        return this.allTypes().stream().filter(CqlField.CqlType::isSupported).collect(Collectors.toList());
    }

    public CqlField.NativeType ascii() {
        return this.cassandraTypes().ascii();
    }

    public CqlField.NativeType blob() {
        return this.cassandraTypes().blob();
    }

    public CqlField.NativeType bool() {
        return this.cassandraTypes().bool();
    }

    public CqlField.NativeType counter() {
        return this.cassandraTypes().counter();
    }

    public CqlField.NativeType bigint() {
        return this.cassandraTypes().bigint();
    }

    public CqlField.NativeType date() {
        return this.cassandraTypes().date();
    }

    public CqlField.NativeType decimal() {
        return this.cassandraTypes().decimal();
    }

    public CqlField.NativeType aDouble() {
        return this.cassandraTypes().aDouble();
    }

    public CqlField.NativeType duration() {
        return this.cassandraTypes().duration();
    }

    public CqlField.NativeType empty() {
        return this.cassandraTypes().empty();
    }

    public CqlField.NativeType aFloat() {
        return this.cassandraTypes().aFloat();
    }

    public CqlField.NativeType inet() {
        return this.cassandraTypes().inet();
    }

    public CqlField.NativeType aInt() {
        return this.cassandraTypes().aInt();
    }

    public CqlField.NativeType smallint() {
        return this.cassandraTypes().smallint();
    }

    public CqlField.NativeType text() {
        return this.cassandraTypes().text();
    }

    public CqlField.NativeType time() {
        return this.cassandraTypes().time();
    }

    public CqlField.NativeType timestamp() {
        return this.cassandraTypes().timestamp();
    }

    public CqlField.NativeType timeuuid() {
        return this.cassandraTypes().timeuuid();
    }

    public CqlField.NativeType tinyint() {
        return this.cassandraTypes().tinyint();
    }

    public CqlField.NativeType uuid() {
        return this.cassandraTypes().uuid();
    }

    public CqlField.NativeType varchar() {
        return this.cassandraTypes().varchar();
    }

    public CqlField.NativeType varint() {
        return this.cassandraTypes().varint();
    }

    public CqlField.CqlType collection(String name, CqlField.CqlType ... types) {
        return this.cassandraTypes().collection(name, types);
    }

    public CqlField.CqlList list(CqlField.CqlType type) {
        return this.cassandraTypes().list(type);
    }

    public CqlField.CqlSet set(CqlField.CqlType type) {
        return this.cassandraTypes().set(type);
    }

    public CqlField.CqlMap map(CqlField.CqlType keyType, CqlField.CqlType valueType) {
        return this.cassandraTypes().map(keyType, valueType);
    }

    public CqlField.CqlTuple tuple(CqlField.CqlType ... types) {
        return this.cassandraTypes().tuple(types);
    }

    public CqlField.CqlType frozen(CqlField.CqlType type) {
        return this.cassandraTypes().frozen(type);
    }

    public CqlField.CqlUdtBuilder udt(String keyspace, String name) {
        return this.cassandraTypes().udt(keyspace, name);
    }

    public CqlField.CqlType parseType(String type) {
        return this.parseType(type, Collections.emptyMap());
    }

    public CqlField.CqlType parseType(String type, Map<String, CqlField.CqlUdt> udts) {
        return this.cassandraTypes().parseType(type, udts);
    }

    public void writeSSTable(Partitioner partitioner, String keyspace, String table, Path directory, String createStatement, String insertStatement, Consumer<Writer> writer) {
        this.writeSSTable(partitioner, keyspace, table, directory, createStatement, insertStatement, null, false, Collections.emptySet(), writer);
    }

    public abstract void writeSSTable(Partitioner var1, String var2, String var3, Path var4, String var5, String var6, String var7, boolean var8, Set<CqlField.CqlUdt> var9, Consumer<Writer> var10);

    public abstract SSTableWriter getSSTableWriter(String var1, String var2, String var3, String var4, Set<String> var5, int var6);

    public abstract SSTableSummary getSSTableSummary(@NotNull String var1, @NotNull String var2, @NotNull SSTable var3);

    public abstract SSTableSummary getSSTableSummary(@NotNull Partitioner var1, @NotNull SSTable var2, int var3, int var4);

    @VisibleForTesting
    public abstract void writeTombstoneSSTable(Partitioner var1, Path var2, String var3, String var4, Consumer<Writer> var5);

    @VisibleForTesting
    public abstract void sstableToJson(Path var1, OutputStream var2) throws FileNotFoundException;

    @VisibleForTesting
    public abstract Object toTupleValue(CqlField.CqlTuple var1, Object[] var2);

    @VisibleForTesting
    public abstract Object toUserTypeValue(CqlField.CqlUdt var1, Map<String, Object> var2);

    public ByteBuffer compress(byte[] bytes) throws IOException {
        return this.compressionUtil().compress(bytes);
    }

    public ByteBuffer compress(ByteBuffer input) throws IOException {
        return this.compressionUtil().compress(input);
    }

    public ByteBuffer uncompress(byte[] bytes) throws IOException {
        return this.compressionUtil().uncompress(bytes);
    }

    public ByteBuffer uncompress(ByteBuffer input) throws IOException {
        return this.compressionUtil().uncompress(input);
    }

    public abstract CompressionUtil compressionUtil();

    public abstract long lastRepairTime(@NotNull String var1, @NotNull String var2, @NotNull SSTable var3) throws IOException;

    public abstract List<Boolean> overlaps(@NotNull SSTable var1, @NotNull Partitioner var2, int var3, int var4, @NotNull List<TokenRange> var5) throws IOException;

    public List<BigInteger> toTokens(@NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createTableStmt, @NotNull List<List<String>> partitionKeys) {
        return this.toTokens(partitioner, this.encodePartitionKeys(partitioner, keyspace, createTableStmt, partitionKeys));
    }

    public List<BigInteger> toTokens(@NotNull Partitioner partitioner, @NotNull List<ByteBuffer> partitionKeys) {
        Tokenizer tokenizer = this.tokenizer(partitioner);
        return partitionKeys.stream().map(tokenizer::toToken).collect(Collectors.toList());
    }

    public abstract Tokenizer tokenizer(@NotNull Partitioner var1);

    public ByteBuffer encodePartitionKey(@NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createTableStmt, @NotNull List<String> partitionKey) {
        return this.encodePartitionKeys(partitioner, keyspace, createTableStmt, Collections.singletonList(partitionKey)).get(0);
    }

    public abstract List<ByteBuffer> encodePartitionKeys(@NotNull Partitioner var1, @NotNull String var2, @NotNull String var3, @NotNull List<List<String>> var4);

    public abstract BloomFilter openBloomFilter(@NotNull Partitioner var1, @NotNull String var2, @NotNull String var3, @NotNull SSTable var4) throws IOException;

    public abstract List<Boolean> contains(@NotNull Partitioner var1, @NotNull String var2, @NotNull String var3, @NotNull SSTable var4, @NotNull List<ByteBuffer> var5) throws IOException;

    public void readStringPartitionKeys(@NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createStmt, @NotNull Set<SSTable> ssTables, @NotNull Consumer<Map<String, Object>> rowConsumer) throws IOException {
        this.readStringPartitionKeys(partitioner, keyspace, createStmt, ssTables, null, null, null, rowConsumer);
    }

    public void readStringPartitionKeys(@NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createStmt, @NotNull Set<SSTable> ssTables, @Nullable TokenRange tokenRange, @Nullable List<List<String>> partitionKeys, @Nullable String[] pruneColumnFilter, @NotNull Consumer<Map<String, Object>> rowConsumer) throws IOException {
        this.readPartitionKeys(partitioner, keyspace, createStmt, (SSTablesSupplier)new BasicSupplier(ssTables), tokenRange, partitionKeys == null ? null : this.encodePartitionKeys(partitioner, keyspace, createStmt, partitionKeys), pruneColumnFilter, rowConsumer);
    }

    public void readPartitionKeys(@NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createStmt, @NotNull Set<SSTable> ssTables, @NotNull Consumer<Map<String, Object>> rowConsumer) throws IOException {
        this.readPartitionKeys(partitioner, keyspace, createStmt, ssTables, null, null, null, rowConsumer);
    }

    public void readPartitionKeys(@NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createStmt, @NotNull Set<SSTable> ssTables, @Nullable TokenRange tokenRange, @Nullable List<ByteBuffer> partitionKeys, @Nullable String[] pruneColumnFilter, @NotNull Consumer<Map<String, Object>> rowConsumer) throws IOException {
        this.readPartitionKeys(partitioner, keyspace, createStmt, (SSTablesSupplier)new BasicSupplier(ssTables), tokenRange, partitionKeys, pruneColumnFilter, rowConsumer);
    }

    public abstract void readPartitionKeys(@NotNull Partitioner var1, @NotNull String var2, @NotNull String var3, @NotNull SSTablesSupplier var4, @Nullable TokenRange var5, @Nullable List<ByteBuffer> var6, @Nullable String[] var7, @NotNull Consumer<Map<String, Object>> var8) throws IOException;

    public abstract void kryoRegister(Kryo var1);

    public abstract void javaSerialize(ObjectOutputStream var1, Serializable var2);

    public abstract <T> T javaDeserialize(ObjectInputStream var1, Class<T> var2);

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] javaSerialize(Serializable object) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream(512);){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
                this.javaSerialize(out, object);
                byArray = bytes.toByteArray();
            }
            return byArray;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T javaDeserialize(byte[] bytes, Class<T> type) {
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            T t = this.javaDeserialize(in, type);
            return t;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @FunctionalInterface
    public static interface Writer {
        public void write(Object ... var1);
    }
}

