/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.function.Function;
import org.apache.cassandra.spark.data.partitioner.MurmurHash;

public enum Partitioner {
    RandomPartitioner(BigInteger.ZERO, BigInteger.valueOf(2L).pow(127).subtract(BigInteger.ONE), key -> {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        md.reset();
        md.update((ByteBuffer)key);
        return new BigInteger(md.digest()).abs();
    }),
    Murmur3Partitioner(BigInteger.valueOf(2L).pow(63).negate(), BigInteger.valueOf(2L).pow(63).subtract(BigInteger.ONE), key -> {
        long value = MurmurHash.hash(key, key.position(), key.remaining(), 0L)[0];
        value = value == Long.MIN_VALUE ? Long.MAX_VALUE : value;
        return BigInteger.valueOf(value);
    });

    private final BigInteger minToken;
    private final BigInteger maxToken;
    private final Function<ByteBuffer, BigInteger> hash;

    public static Partitioner from(String partitionerClass) {
        switch (partitionerClass) {
            case "org.apache.cassandra.dht.Murmur3Partitioner": 
            case "Murmur3Partitioner": {
                return Murmur3Partitioner;
            }
            case "org.apache.cassandra.dht.RandomPartitioner": 
            case "RandomPartitioner": {
                return RandomPartitioner;
            }
        }
        throw new UnsupportedOperationException("Unexpected partitioner: " + partitionerClass);
    }

    private Partitioner(BigInteger minToken, BigInteger maxToken, Function<ByteBuffer, BigInteger> hash) {
        this.minToken = minToken;
        this.maxToken = maxToken;
        this.hash = hash;
    }

    public BigInteger minToken() {
        return this.minToken;
    }

    public BigInteger maxToken() {
        return this.maxToken;
    }

    public BigInteger hash(ByteBuffer key) {
        return this.hash.apply(key);
    }

    public String toString() {
        return "org.apache.cassandra.dht." + super.toString();
    }
}

