/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.RoutingType;

public class AMQPBridgeReceiverInfo {
    private final ReceiverRole role;
    private final String localAddress;
    private final String localQueue;
    private final String localFqqn;
    private final String remoteAddress;
    private final RoutingType routingType;
    private final String filterString;
    private final String id;
    private final Integer priority;

    public AMQPBridgeReceiverInfo(ReceiverRole role, String localAddress, String localQueue, RoutingType routingType, String remoteAddress, String filterString, Integer priority) {
        this.role = role;
        this.localAddress = localAddress;
        this.localQueue = localQueue;
        this.routingType = routingType;
        this.localFqqn = role == ReceiverRole.QUEUE_RECEIVER ? localAddress + "::" + localQueue : null;
        this.remoteAddress = remoteAddress;
        this.filterString = filterString;
        this.priority = priority;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public ReceiverRole getRole() {
        return this.role;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getLocalQueue() {
        return this.localQueue;
    }

    public String getLocalFqqn() {
        return this.localFqqn;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterString, this.localAddress, this.localFqqn, this.localQueue, this.remoteAddress, this.role, this.routingType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AMQPBridgeReceiverInfo)) {
            return false;
        }
        AMQPBridgeReceiverInfo other = (AMQPBridgeReceiverInfo)obj;
        return Objects.equals(this.filterString, other.filterString) && Objects.equals(this.localAddress, other.localAddress) && Objects.equals(this.localFqqn, other.localFqqn) && Objects.equals(this.localQueue, other.localQueue) && Objects.equals(this.remoteAddress, other.remoteAddress) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.routingType, other.routingType);
    }

    public String toString() {
        return "AMQPBridgeReceiverInfo: { " + this.getLocalAddress() + ", " + this.getLocalQueue() + ", " + this.getLocalFqqn() + ", " + String.valueOf(this.getRoutingType()) + ", " + String.valueOf((Object)this.getRole()) + ", " + this.getRemoteAddress() + ", " + this.getPriority() + ", " + this.getFilterString() + " }";
    }

    static enum ReceiverRole {
        ADDRESS_RECEIVER,
        QUEUE_RECEIVER;

    }
}

