/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.utils.BufferHelper;

public class SessionQueueQueryResponseMessage_V3
extends SessionQueueQueryResponseMessage_V2 {
    protected boolean autoCreated;
    protected boolean purgeOnNoConsumers;
    protected RoutingType routingType;
    protected int maxConsumers;
    protected Boolean exclusive;
    protected Boolean groupRebalance;
    protected Boolean groupRebalancePauseDispatch;
    protected Integer groupBuckets;
    protected SimpleString groupFirstKey;
    protected Boolean lastValue;
    protected SimpleString lastValueKey;
    protected Boolean nonDestructive;
    private Integer consumersBeforeDispatch;
    private Long delayBeforeDispatch;
    private Boolean autoDelete;
    private Long autoDeleteDelay;
    private Long autoDeleteMessageCount;
    protected Integer defaultConsumerWindowSize;
    private Long ringSize;
    private Boolean enabled;
    private Boolean configurationManaged;

    public SessionQueueQueryResponseMessage_V3(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists(), result.isAutoCreateQueues(), result.isAutoCreated(), result.isPurgeOnNoConsumers(), result.getRoutingType(), result.getMaxConsumers(), result.isExclusive(), result.isGroupRebalance(), result.isGroupRebalancePauseDispatch(), result.getGroupBuckets(), result.getGroupFirstKey(), result.isLastValue(), result.getLastValueKey(), result.isNonDestructive(), result.getConsumersBeforeDispatch(), result.getDelayBeforeDispatch(), result.isAutoDelete(), result.getAutoDeleteDelay(), result.getAutoDeleteMessageCount(), result.getDefaultConsumerWindowSize(), result.getRingSize(), result.isEnabled(), result.isConfigurationManaged());
    }

    public SessionQueueQueryResponseMessage_V3() {
        this(null, null, false, false, null, 0, 0L, false, false, false, false, RoutingType.MULTICAST, -1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private SessionQueueQueryResponseMessage_V3(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists, boolean autoCreateQueues, boolean autoCreated, boolean purgeOnNoConsumers, RoutingType routingType, int maxConsumers, Boolean exclusive, Boolean groupRebalance, Boolean groupRebalancePauseDispatch, Integer groupBuckets, SimpleString groupFirstKey, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, Integer defaultConsumerWindowSize, Long ringSize, Boolean enabled, Boolean configurationManaged) {
        super((byte)-14);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreated = autoCreated;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
        this.exclusive = exclusive;
        this.groupRebalance = groupRebalance;
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
        this.groupBuckets = groupBuckets;
        this.groupFirstKey = groupFirstKey;
        this.lastValue = lastValue;
        this.lastValueKey = lastValueKey;
        this.nonDestructive = nonDestructive;
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        this.delayBeforeDispatch = delayBeforeDispatch;
        this.autoDelete = autoDelete;
        this.autoDeleteDelay = autoDeleteDelay;
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        this.ringSize = ringSize;
        this.enabled = enabled;
        this.configurationManaged = configurationManaged;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
    }

    public SimpleString getLastValueKey() {
        return this.lastValueKey;
    }

    public void setLastValueKey(SimpleString lastValueKey) {
        this.lastValueKey = lastValueKey;
    }

    public Boolean isNonDestructive() {
        return this.nonDestructive;
    }

    public void setNonDestructive(Boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
    }

    public Integer getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    public void setConsumersBeforeDispatch(Integer consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
    }

    public Long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    public void setDelayBeforeDispatch(Long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
    }

    public Integer getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize;
    }

    public void setDefaultConsumerWindowSize(Integer defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
    }

    public Boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    public void setGroupRebalance(Boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
    }

    public Boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    public void setGroupRebalancePauseDispatch(Boolean groupRebalancePauseDispatch) {
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
    }

    public Integer getGroupBuckets() {
        return this.groupBuckets;
    }

    public void setGroupBuckets(Integer groupBuckets) {
        this.groupBuckets = groupBuckets;
    }

    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    public void setGroupFirstKey(SimpleString groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
    }

    public Boolean isAutoDelete() {
        return this.autoDelete;
    }

    public Long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public Long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public Long getRingSize() {
        return this.ringSize;
    }

    public void setRingSize(Long ringSize) {
        this.ringSize = ringSize;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isConfigurationManaged() {
        return this.configurationManaged;
    }

    public void setConfigurationManaged(Boolean configurationManaged) {
        this.configurationManaged = configurationManaged;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.autoCreated);
        buffer.writeBoolean(this.purgeOnNoConsumers);
        buffer.writeByte(this.routingType.getType());
        buffer.writeInt(this.maxConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.exclusive);
        BufferHelper.writeNullableBoolean(buffer, this.lastValue);
        BufferHelper.writeNullableInteger(buffer, this.defaultConsumerWindowSize);
        buffer.writeNullableSimpleString(this.lastValueKey);
        BufferHelper.writeNullableBoolean(buffer, this.nonDestructive);
        BufferHelper.writeNullableInteger(buffer, this.consumersBeforeDispatch);
        BufferHelper.writeNullableLong(buffer, this.delayBeforeDispatch);
        BufferHelper.writeNullableBoolean(buffer, this.groupRebalance);
        BufferHelper.writeNullableInteger(buffer, this.groupBuckets);
        BufferHelper.writeNullableBoolean(buffer, this.autoDelete);
        BufferHelper.writeNullableLong(buffer, this.autoDeleteDelay);
        BufferHelper.writeNullableLong(buffer, this.autoDeleteMessageCount);
        buffer.writeNullableSimpleString(this.groupFirstKey);
        BufferHelper.writeNullableLong(buffer, this.ringSize);
        BufferHelper.writeNullableBoolean(buffer, this.enabled);
        BufferHelper.writeNullableBoolean(buffer, this.groupRebalancePauseDispatch);
        BufferHelper.writeNullableBoolean(buffer, this.configurationManaged);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.autoCreated = buffer.readBoolean();
        this.purgeOnNoConsumers = buffer.readBoolean();
        this.routingType = RoutingType.getType((byte)buffer.readByte());
        this.maxConsumers = buffer.readInt();
        if (buffer.readableBytes() > 0) {
            this.exclusive = BufferHelper.readNullableBoolean(buffer);
            this.lastValue = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumerWindowSize = BufferHelper.readNullableInteger(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.lastValueKey = buffer.readNullableSimpleString();
            this.nonDestructive = BufferHelper.readNullableBoolean(buffer);
            this.consumersBeforeDispatch = BufferHelper.readNullableInteger(buffer);
            this.delayBeforeDispatch = BufferHelper.readNullableLong(buffer);
            this.groupRebalance = BufferHelper.readNullableBoolean(buffer);
            this.groupBuckets = BufferHelper.readNullableInteger(buffer);
            this.autoDelete = BufferHelper.readNullableBoolean(buffer);
            this.autoDeleteDelay = BufferHelper.readNullableLong(buffer);
            this.autoDeleteMessageCount = BufferHelper.readNullableLong(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.groupFirstKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.ringSize = BufferHelper.readNullableLong(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.enabled = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.groupRebalancePauseDispatch = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.configurationManaged = BufferHelper.readNullableBoolean(buffer);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.autoCreated, this.purgeOnNoConsumers, this.routingType, this.maxConsumers, this.exclusive, this.groupRebalance, this.groupRebalancePauseDispatch, this.groupBuckets, this.groupFirstKey, this.lastValue, this.lastValueKey, this.nonDestructive, this.consumersBeforeDispatch, this.delayBeforeDispatch, this.autoDelete, this.autoDeleteDelay, this.autoDeleteMessageCount, this.defaultConsumerWindowSize, this.ringSize, this.enabled, this.configurationManaged);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", autoCreated=" + this.autoCreated);
        sb.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        sb.append(", routingType=" + String.valueOf(this.routingType));
        sb.append(", maxConsumers=" + this.maxConsumers);
        sb.append(", exclusive=" + this.exclusive);
        sb.append(", groupRebalance=" + this.groupRebalance);
        sb.append(", groupRebalancePauseDispatch=" + this.groupRebalancePauseDispatch);
        sb.append(", groupBuckets=" + this.groupBuckets);
        sb.append(", groupFirstKey=" + String.valueOf(this.groupFirstKey));
        sb.append(", lastValue=" + this.lastValue);
        sb.append(", lastValueKey=" + String.valueOf(this.lastValueKey));
        sb.append(", nonDestructive=" + this.nonDestructive);
        sb.append(", consumersBeforeDispatch=" + this.consumersBeforeDispatch);
        sb.append(", delayBeforeDispatch=" + this.delayBeforeDispatch);
        sb.append(", autoDelete=" + this.autoDelete);
        sb.append(", autoDeleteDelay=" + this.autoDeleteDelay);
        sb.append(", autoDeleteMessageCount=" + this.autoDeleteMessageCount);
        sb.append(", defaultConsumerWindowSize=" + this.defaultConsumerWindowSize);
        sb.append(", ringSize=" + this.ringSize);
        sb.append(", enabled=" + this.enabled);
        sb.append(", configurationManaged=" + this.configurationManaged);
        return sb.toString();
    }

    @Override
    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists(), this.isAutoCreateQueues(), this.getMaxConsumers(), this.isAutoCreated(), this.isPurgeOnNoConsumers(), this.getRoutingType(), this.isExclusive(), this.isGroupRebalance(), this.isGroupRebalancePauseDispatch(), this.getGroupBuckets(), this.getGroupFirstKey(), this.isLastValue(), this.getLastValueKey(), this.isNonDestructive(), this.getConsumersBeforeDispatch(), this.getDelayBeforeDispatch(), this.isAutoDelete(), this.getAutoDeleteDelay(), this.getAutoDeleteMessageCount(), this.getDefaultConsumerWindowSize(), this.getRingSize(), this.isEnabled(), this.isConfigurationManaged());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage_V3)) {
            return false;
        }
        SessionQueueQueryResponseMessage_V3 other = (SessionQueueQueryResponseMessage_V3)obj;
        return this.autoCreated == other.autoCreated && this.purgeOnNoConsumers == other.purgeOnNoConsumers && this.maxConsumers == other.maxConsumers && Objects.equals(this.exclusive, other.exclusive) && Objects.equals(this.groupRebalance, other.groupRebalance) && Objects.equals(this.groupRebalancePauseDispatch, other.groupRebalancePauseDispatch) && Objects.equals(this.groupBuckets, other.groupBuckets) && Objects.equals(this.groupFirstKey, other.groupFirstKey) && Objects.equals(this.lastValue, other.lastValue) && Objects.equals(this.lastValueKey, other.lastValueKey) && Objects.equals(this.nonDestructive, other.nonDestructive) && Objects.equals(this.consumersBeforeDispatch, other.consumersBeforeDispatch) && Objects.equals(this.delayBeforeDispatch, other.delayBeforeDispatch) && Objects.equals(this.autoDelete, other.autoDelete) && Objects.equals(this.autoDeleteDelay, other.autoDeleteDelay) && Objects.equals(this.autoDeleteMessageCount, other.autoDeleteMessageCount) && Objects.equals(this.ringSize, other.ringSize) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.defaultConsumerWindowSize, other.defaultConsumerWindowSize) && Objects.equals(this.routingType, other.routingType) && Objects.equals(this.configurationManaged, other.configurationManaged);
    }
}

