/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public enum ConfigKey {
    HISTORY_MAX_ENTRIES("historyMaxEntries", true, false, "10"),
    DEBUG("debug", true, false, "false"),
    DEBUG_MAX_ENTRIES("debugMaxEntries", true, false, "100"),
    JSR160_PROXY_ALLOWED_TARGETS("jsr160ProxyAllowedTargets", true, false),
    LOGHANDLER_CLASS("logHandlerClass", true, false),
    LOGHANDLER_NAME("logHandlerName", true, false, "org.jolokia"),
    MAX_DEPTH("maxDepth", true, true, null, Integer.class),
    MAX_COLLECTION_SIZE("maxCollectionSize", true, true, null, Integer.class),
    MAX_OBJECTS("maxObjects", true, true, null, Integer.class),
    SERIALIZE_LONG("serializeLong", true, true, null, String.class),
    RESTRICTOR_CLASS("restrictorClass", true, false),
    POLICY_LOCATION("policyLocation", true, false, "classpath:/jolokia-access.xml"),
    ALLOW_DNS_REVERSE_LOOKUP("allowDnsReverseLookup", true, false, "false"),
    IGNORE_ERRORS("ignoreErrors", false, true, null, String.class),
    INCLUDE_STACKTRACE("includeStackTrace", true, true, "false", String.class),
    SERIALIZE_EXCEPTION("serializeException", true, true, "false", Boolean.class),
    ALLOW_ERROR_DETAILS("allowErrorDetails", true, false, "true"),
    CANONICAL_NAMING("canonicalNaming", true, true, "true", Boolean.class),
    STREAMING("streaming", true, false, "true"),
    MBEAN_QUALIFIER("mbeanQualifier", true, false),
    CALLBACK("callback", false, true, null, String.class),
    MIME_TYPE("mimeType", true, true, "application/json", String.class),
    INCLUDE_REQUEST("includeRequest", true, true, null, Boolean.class),
    LIST_KEYS("listKeys", false, true, "false", Boolean.class),
    IF_MODIFIED_SINCE("ifModifiedSince", false, true, null, Integer.class),
    PATH_QUERY_PARAM("p", false, true, null, String.class),
    DISCOVERY_ENABLED("discoveryEnabled", true, false, "false"),
    DISCOVERY_AGENT_URL("discoveryAgentUrl", true, false),
    MULTICAST_GROUP("multicastGroup", true, false, "239.192.48.84"),
    MULTICAST_BIND_ADDRESS("multicastBindAddress", true, false, "0.0.0.0"),
    MULTICAST_PORT("multicastPort", true, false, "24884"),
    USER("user", true, false),
    PASSWORD("password", true, false),
    REALM("realm", true, false, "jolokia"),
    BASIC_AUTHENTICATION_REALM("basicAuthenticationRealm", true, false),
    MTLS_AUTHENTICATION_ENABLED("mtlsAuthenticationEnabled", true, false, null, Boolean.class),
    AUTH_MODE("authMode", true, false, "basic"),
    AUTH_MATCH("authMatch", true, false, "any"),
    AUTH_CLASS("authClass", true, false),
    AUTH_URL("authUrl", true, false),
    AUTH_PRINCIPAL_SPEC("authPrincipalSpec", true, false),
    AUTH_IGNORE_CERTS("authIgnoreCerts", true, false, "false"),
    AGENT_CONTEXT("agentContext", true, false, "/jolokia"),
    USE_RESTRICTOR_SERVICE("useRestrictorService", true, false, "false"),
    LISTEN_FOR_HTTP_SERVICE("listenForHttpService", true, false),
    REGISTER_WHITEBOARD_SERVLET("registerWhiteboardServlet", true, false, "true"),
    HTTP_SERVICE_FILTER("httpServiceFilter", true, false),
    DISABLE_DETECTORS("disableDetectors", true, false, "false"),
    DETECTOR_OPTIONS("detectorOptions", true, false),
    AGENT_ID("agentId", true, false),
    AGENT_TYPE("agentType", true, false),
    AGENT_DESCRIPTION("agentDescription", true, false),
    ENABLED_SERVICES("enabledServices", true, false),
    DISABLED_SERVICES("disabledServices", true, false),
    DATE_FORMAT("dateFormat", true, false, "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSXXX"),
    DATE_FORMAT_ZONE("dateFormatTimeZone", true, false, TimeZone.getDefault().toZoneId().getId()),
    LIST_CACHE("listCache", false, true, "false", Boolean.class);

    public static final String JAAS_SUBJECT_REQUEST_ATTRIBUTE = "org.jolokia.jaasSubject";
    private final String key;
    private final String defaultValue;
    private final boolean globalConfig;
    private final boolean requestConfig;
    private final Class<?> type;
    private static final Map<String, ConfigKey> keyByName;
    private static final Map<String, ConfigKey> globalKeyByName;
    private static final Map<String, ConfigKey> requestKeyByName;
    public static final Set<String> enabledValues;
    public static final Set<String> disabledValues;

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig) {
        this(pValue, pIsGlobalConfig, pIsRequestConfig, null);
    }

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig, String pDefault) {
        this(pValue, pIsGlobalConfig, pIsRequestConfig, pDefault, null);
    }

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig, String pDefault, Class<?> pType) {
        this.key = pValue;
        this.defaultValue = pDefault;
        this.globalConfig = pIsGlobalConfig;
        this.requestConfig = pIsRequestConfig;
        this.type = pType;
    }

    public String toString() {
        return this.key;
    }

    public static ConfigKey getGlobalConfigKey(String pKeyS) {
        return globalKeyByName.get(pKeyS);
    }

    public static ConfigKey getRequestConfigKey(String pKeyS) {
        return requestKeyByName.get(pKeyS);
    }

    public String getKeyValue() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isGlobalConfig() {
        return this.globalConfig;
    }

    public boolean isRequestConfig() {
        return this.requestConfig;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String asSystemProperty() {
        return "jolokia." + this.getKeyValue();
    }

    public String asEnvVariable() {
        String kevValue = this.getKeyValue();
        StringBuilder buf = new StringBuilder();
        boolean notFirst = false;
        for (char c : kevValue.toCharArray()) {
            if (Character.isUpperCase(c) && notFirst) {
                buf.append("_").append(c);
            } else {
                buf.append(Character.toUpperCase(c));
            }
            notFirst = true;
        }
        return "JOLOKIA_" + String.valueOf(buf);
    }

    public static ConfigKey fromEnvVariable(String key) {
        if (!key.startsWith("JOLOKIA_")) {
            return null;
        }
        String k = ConfigKey.fromEnvVariableFormat(key);
        return k == null ? null : ConfigKey.getGlobalConfigKey(k);
    }

    public static String fromEnvVariableFormat(String key) {
        if (!key.startsWith("JOLOKIA_")) {
            return null;
        }
        key = key.substring("JOLOKIA_".length());
        String[] parts = key.split("_");
        StringBuilder buf = new StringBuilder();
        buf.append(parts[0].toLowerCase());
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            buf.append(Character.toUpperCase(parts[i].charAt(0))).append(parts[i].substring(1).toLowerCase());
        }
        return buf.toString();
    }

    static {
        enabledValues = Set.of("true", "on", "yes", "y", "1");
        disabledValues = Set.of("false", "off", "no", "n", "0");
        keyByName = new HashMap<String, ConfigKey>();
        globalKeyByName = new HashMap<String, ConfigKey>();
        requestKeyByName = new HashMap<String, ConfigKey>();
        for (ConfigKey ck : ConfigKey.values()) {
            keyByName.put(ck.getKeyValue(), ck);
            if (ck.isGlobalConfig()) {
                globalKeyByName.put(ck.getKeyValue(), ck);
            }
            if (!ck.isRequestConfig()) continue;
            requestKeyByName.put(ck.getKeyValue(), ck);
        }
    }

    private static class Constants {
        public static final String FALSE = "false";
        public static final String TRUE = "true";

        private Constants() {
        }
    }
}

